/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.hbase.test;

import java.util.Date;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Before;
import org.junit.Test;
import org.sharengo.wikitty.hbase.WikittyHBaseUtil;
import org.sharengo.wikitty.hbase.test.AbstractTestHbase;

public class HBaseConnectorTest
extends AbstractTestHbase {
    protected static final Log log = LogFactory.getLog(HBaseConnectorTest.class);
    public static final byte[] Q_TEST = Bytes.toBytes((String)"test");
    protected HTable hTable;

    @Before
    public void setUp() throws Exception {
        this.hTable = new HTable(WikittyHBaseUtil.getHBaseConfiguration(), WikittyHBaseUtil.T_WIKITTY);
    }

    @Test
    public void testCRUD() throws Exception {
        String uuid = UUID.randomUUID().toString();
        byte[] id = Bytes.toBytes((String)uuid);
        Put put = new Put(id);
        put.add(WikittyHBaseUtil.F_DATA, Q_TEST, Bytes.toBytes((int)123));
        this.hTable.put(put);
        Get get = new Get(id);
        Result row = this.hTable.get(get);
        int value = Bytes.toInt((byte[])row.getValue(WikittyHBaseUtil.F_DATA, Q_TEST));
        Assert.assertEquals((int)123, (int)value);
        put = new Put(id);
        put.add(WikittyHBaseUtil.F_DATA, Q_TEST, Bytes.toBytes((int)321));
        this.hTable.put(put);
        row = this.hTable.get(get);
        value = Bytes.toInt((byte[])row.getValue(WikittyHBaseUtil.F_DATA, Q_TEST));
        Assert.assertEquals((int)321, (int)value);
        Delete delete = new Delete(id);
        this.hTable.delete(delete);
        Assert.assertFalse((boolean)this.hTable.exists(get));
    }

    public void _testLoop() throws Exception {
        int j;
        int j2;
        HTable hTable = new HTable(new HBaseConfiguration(), WikittyHBaseUtil.T_WIKITTY);
        byte[] rowId = Bytes.toBytes((String)"Test");
        for (j2 = 0; j2 < 10; ++j2) {
            Put put = new Put(rowId);
            put.setTimeStamp(this.getTime());
            put.add(Bytes.toBytes((String)"data"), Bytes.toBytes((String)("1:" + j2)), Bytes.toBytes((int)j2));
            hTable.put(put);
        }
        for (j2 = 0; j2 < 10; ++j2) {
            Get get = new Get(rowId);
            Result row = hTable.get(get);
            if (row.getValue(Bytes.toBytes((String)"data"), Bytes.toBytes((String)("1:" + j2))) != null) continue;
            throw new Exception("Error 1");
        }
        Delete delete = new Delete(rowId, this.getTime(), null);
        hTable.delete(delete);
        for (j = 0; j < 10; ++j) {
            Put put = new Put(rowId);
            put.setTimeStamp(this.getTime());
            put.add(Bytes.toBytes((String)"data"), Bytes.toBytes((String)("2:" + j)), Bytes.toBytes((int)j));
            hTable.put(put);
        }
        for (j = 0; j < 10; ++j) {
            Get get = new Get(rowId);
            Result row = hTable.get(get);
            hTable.close();
            if (row.getValue(Bytes.toBytes((String)"data"), Bytes.toBytes((String)("2:" + j))) != null) continue;
            throw new Exception("Error 2");
        }
    }

    protected long getTime() {
        long result = new Date().getTime();
        log.debug((Object)("[Timespan operation]" + result));
        return result;
    }
}

