/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.test.conform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.Tree;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Search;
import org.sharengo.wikitty.test.conform.AbstractTestConformance;

public class StorageTest
extends AbstractTestConformance {
    protected static final Log log = LogFactory.getLog(StorageTest.class);

    @Test
    public void testStoreRestoreBasics() throws Exception {
        Wikitty w = StorageTest.createBasicWikitty();
        String id = w.getId();
        this.ws.store(w);
        w = this.ws.restore(id);
        junit.framework.Assert.assertTrue((boolean)w.hasExtension("wikittyExt"));
        for (int i = 0; i < 3; ++i) {
            junit.framework.Assert.assertTrue((boolean)w.hasField("wikittyExt", "fieldName" + i));
        }
    }

    @Test
    public void testExtensionMethod() throws Exception {
        this.ws.storeExtension(Arrays.asList(EXT_TEST));
        List extIds = this.ws.getAllExtensionIds();
        log.debug((Object)("extIds: " + extIds));
        junit.framework.Assert.assertEquals((int)1, (int)extIds.size());
        WikittyExtension ext = this.ws.restoreExtension((String)extIds.get(0));
        junit.framework.Assert.assertEquals((String)EXT_TEST.getName(), (String)ext.getName());
        junit.framework.Assert.assertEquals((String)EXT_TEST.getVersion(), (String)ext.getVersion());
        junit.framework.Assert.assertEquals((Object)EXT_TEST, (Object)ext);
    }

    @Test
    public void testExtensionRequires() throws Exception {
        this.ws.storeExtension(Arrays.asList(EXT_REQUIRED, EXT_REQUIRES));
        List extIds = this.ws.getAllExtensionsRequires("wikittyRequired");
        log.debug((Object)("extIds: " + extIds));
        junit.framework.Assert.assertEquals((int)1, (int)extIds.size());
        WikittyExtension ext = this.ws.restoreExtension((String)extIds.get(0));
        junit.framework.Assert.assertEquals((String)EXT_REQUIRES.getName(), (String)ext.getName());
        junit.framework.Assert.assertEquals((String)EXT_REQUIRES.getVersion(), (String)ext.getVersion());
        junit.framework.Assert.assertEquals((Object)EXT_REQUIRES, (Object)ext);
    }

    @Test
    public void testStoreRestoreLists() throws Exception {
        String[] wValues;
        List<Wikitty> wikitties = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        for (String wValue : wValues = new String[]{"fieldName0 = hello,fieldName1 = 123456,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = Bonzai !,fieldName1 = 111111,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = ho ho ho !,fieldName1 = 987654,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
            ids.add(w.getId());
        }
        this.ws.store(wikitties);
        wikitties = this.ws.restore(ids);
        int wIndex = 0;
        for (String wValue : wValues) {
            Wikitty w = (Wikitty)wikitties.get(wIndex);
            int i = 0;
            for (Map.Entry<String, String> keyValuePair : StorageTest.getKeyPairs(wValue)) {
                String fieldName = "fieldName" + i;
                junit.framework.Assert.assertEquals((String)fieldName, (String)keyValuePair.getKey());
                String errorMsg = "Error check field '" + fieldName + "' on wikitty[" + i + "]";
                switch (i) {
                    case 0: {
                        junit.framework.Assert.assertEquals((String)errorMsg, (String)keyValuePair.getValue(), (String)w.getFieldAsString("wikittyExt", fieldName));
                        break;
                    }
                    case 1: {
                        junit.framework.Assert.assertEquals((String)errorMsg, (int)Integer.parseInt(keyValuePair.getValue()), (int)w.getFieldAsInt("wikittyExt", fieldName));
                        break;
                    }
                    case 2: {
                        junit.framework.Assert.assertEquals((String)errorMsg, (Object)WikittyUtil.solrDateFormat.parseObject(keyValuePair.getValue()), (Object)w.getFieldAsDate("wikittyExt", fieldName));
                        break;
                    }
                    default: {
                        junit.framework.Assert.fail((String)("this structure should only get 3 elements, unexpected : " + keyValuePair.getKey()));
                    }
                }
                ++i;
            }
            ++wIndex;
        }
    }

    @Test
    public void testStoreRestoreNullEmpty() throws Exception {
        Wikitty w = null;
        try {
            this.ws.store(w);
            junit.framework.Assert.fail((String)"store(null) Must throw an exception !");
        }
        catch (Exception e) {
            // empty catch block
        }
        w = new Wikitty();
        String id = w.getId();
        this.ws.store(w);
        w = this.ws.restore(id);
        junit.framework.Assert.assertEquals((String)id, (String)w.getId());
    }

    @Test
    public void testFieldConstraint() throws Exception {
        WikittyExtension ext = new WikittyExtension("TestConstraint", "1", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String id not null", "String ext[0-n] unique", "String other[0-n] unique not null"}));
        this.ws.storeExtension(Arrays.asList(ext));
        Wikitty w = new Wikitty();
        w.addExtension(ext);
        try {
            this.ws.store(w);
            junit.framework.Assert.assertFalse((String)"not null contraint don't work on String", (boolean)true);
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.setField("TestConstraint", "id", (Object)"toto");
        try {
            this.ws.store(w);
            junit.framework.Assert.assertFalse((String)"not null contraint don't work in Collection", (boolean)true);
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.addToField("TestConstraint", "other", (Object)"titi");
        this.ws.store(w);
        w.addToField("TestConstraint", "ext", (Object)"tata");
        w.addToField("TestConstraint", "ext", (Object)"titi");
        this.ws.store(w);
        Wikitty w2 = this.ws.restore(w.getId());
        w2.addToField("TestConstraint", "ext", (Object)"tata");
        w2.addToField("TestConstraint", "ext", (Object)"toto");
        this.ws.store(w2);
        Wikitty w3 = this.ws.restore(w.getId());
        HashSet<String> set = new HashSet<String>(Arrays.asList("tata", "titi", "toto"));
        junit.framework.Assert.assertEquals(set, (Object)w3.getFieldAsSet("TestConstraint", "ext", String.class));
    }

    @Test
    public void testStoreFindAll() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003309,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 003309,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        this.ws.store(wikitties);
        Wikitty w = new Wikitty();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"003309");
        Criteria criteria = Search.query((Wikitty)w).criteria().addSortDescending(EXT_TEST.getName() + ".fieldName0");
        PagedResult resultFind = this.ws.findAllByCriteria(criteria);
        junit.framework.Assert.assertEquals((int)2, (int)resultFind.size());
        junit.framework.Assert.assertEquals(wikitties.subList(0, 2), (Object)resultFind.getAll());
    }

    @Test
    public void testStoreFindAllFacet() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 663300,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 663300,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        this.ws.store(wikitties);
        Wikitty w = new Wikitty();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"663300");
        Criteria criteria = Search.query((Wikitty)w).criteria().setFirstIndex(0).setEndIndex(-1).addFacetField(EXT_TEST.getName() + ".fieldName0").addFacetField(EXT_TEST.getName() + ".fieldName1");
        PagedResult resultFind = this.ws.findAllByCriteria(criteria);
        ArrayList facetNames = new ArrayList(resultFind.getFacetNames());
        Collections.sort(facetNames);
        junit.framework.Assert.assertEquals(Arrays.asList(EXT_TEST.getName() + ".fieldName0", EXT_TEST.getName() + ".fieldName1"), facetNames);
        junit.framework.Assert.assertEquals((int)2, (int)resultFind.getTopic(EXT_TEST.getName() + ".fieldName0").size());
        junit.framework.Assert.assertEquals((int)1, (int)resultFind.getTopic(EXT_TEST.getName() + ".fieldName1").size());
    }

    @Test
    public void testStoreFindDelete() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003301,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaiseICI,fieldName1 = 113312,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223323,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        HashMap<String, String> oldIdVersion = new HashMap<String, String>();
        for (Wikitty w : wikitties) {
            oldIdVersion.put(w.getId(), w.getVersion());
        }
        UpdateResponse response = this.ws.store(wikitties);
        for (Wikitty w : wikitties) {
            response.update(w);
            String v1 = w.getVersion();
            String v2 = (String)oldIdVersion.get(w.getId());
            junit.framework.Assert.assertNotNull((Object)v1);
            junit.framework.Assert.assertNotNull((Object)v2);
            junit.framework.Assert.assertTrue((boolean)WikittyUtil.versionGreaterThan((String)v1, (String)v2));
        }
        Wikitty w = new Wikitty();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName0", (Object)"chaiseICI");
        Criteria criteria = Search.query((Wikitty)w).criteria();
        Wikitty resultFind = this.ws.findByCriteria(criteria);
        Wikitty wikittySource = (Wikitty)wikitties.get(1);
        junit.framework.Assert.assertEquals((String)w.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (String)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        junit.framework.Assert.assertEquals((String)wikittySource.getId(), (String)resultFind.getId());
        junit.framework.Assert.assertEquals((Object)wikittySource, (Object)resultFind);
        junit.framework.Assert.assertEquals((String)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (String)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        junit.framework.Assert.assertEquals((String)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName1"), (String)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName1"));
        junit.framework.Assert.assertEquals((String)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName2"), (String)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName2"));
        Criteria criteria1 = Search.query().eq("id", wikittySource.getId()).criteria();
        Wikitty searchedWikitty1 = this.ws.findByCriteria(criteria1);
        Assert.assertNotNull((Object)searchedWikitty1);
        this.ws.delete(wikittySource.getId());
        Wikitty deletedObject = this.ws.restore(wikittySource.getId());
        junit.framework.Assert.assertNull((Object)deletedObject);
        Criteria criteria2 = Search.query().eq("id", wikittySource.getId()).criteria();
        Wikitty searchedWikitty2 = this.ws.findByCriteria(criteria2);
        Assert.assertNull((Object)searchedWikitty2);
    }

    @Test
    public void testStoreAndLabel() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.ws);
        long ts = new Date().getTime();
        Wikitty w1 = (Wikitty)wikitties.get(0);
        this.ws.addLabel(w1.getId(), "titi" + ts);
        this.ws.addLabel(w1.getId(), "toto" + ts);
        Wikitty w2 = (Wikitty)wikitties.get(1);
        this.ws.addLabel(w2.getId(), "tata" + ts);
        this.ws.addLabel(w2.getId(), "titi" + ts);
        Wikitty w3 = (Wikitty)wikitties.get(2);
        this.ws.addLabel(w3.getId(), "tutu" + ts);
        this.ws.addLabel(w3.getId(), "titi" + ts);
        Wikitty wt = this.ws.findByLabel("toto" + ts);
        junit.framework.Assert.assertEquals((Object)w1, (Object)wt);
        Set labels = this.ws.findAllAppliedLabels(w2.getId());
        junit.framework.Assert.assertEquals(new HashSet<String>(Arrays.asList("tata" + ts, "titi" + ts)), (Object)labels);
    }

    @Test
    public void testStoreAndClassification() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.ws);
        ArrayList<Wikitty> wikittyNodes = new ArrayList<Wikitty>();
        TreeNodeImpl root = new TreeNodeImpl();
        wikittyNodes.add(root.getWikitty());
        root.setName("MyCategoryRoot");
        for (int i = 0; i < 3; ++i) {
            TreeNodeImpl leaf = new TreeNodeImpl();
            wikittyNodes.add(leaf.getWikitty());
            leaf.setName("cat-" + i);
            leaf.setParent(root.getWikittyId());
            for (int j = 0; j < 5; ++j) {
                TreeNodeImpl subLeaf = new TreeNodeImpl();
                subLeaf.setName("subcat-" + i + "-" + j);
                subLeaf.setParent(leaf.getWikittyId());
                wikittyNodes.add(subLeaf.getWikitty());
            }
        }
        this.ws.store(wikittyNodes);
        Wikitty table = (Wikitty)wikitties.get(0);
        Wikitty chaise = (Wikitty)wikitties.get(1);
        Wikitty bureau = (Wikitty)wikitties.get(2);
        this.assign(chaise, root, "cat-1/subcat-1-4");
        this.assign(table, root, "cat-1");
        this.assign(bureau, root, "cat-2/subcat-2-4");
        Tree t = this.ws.restoreTree(root.getWikitty().getId());
        t.getName().equals("MyCategoryRoot");
    }

    private void assign(Wikitty wikitty, TreeNodeImpl root, String path) {
        String[] nodeNames = path.split("/");
        TreeNodeImpl currentNode = root;
        block0: for (String nodeName : nodeNames) {
            TreeNodeImpl node = new TreeNodeImpl();
            node.setName(nodeName);
            Criteria criteria = Search.query((Wikitty)node.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
            List wikitties = this.ws.findAllByCriteria(criteria).getAll();
            for (Wikitty child : wikitties) {
                if (!child.hasExtension("TreeNode") || !(node = new TreeNodeImpl(child)).getName().equals(nodeName)) continue;
                currentNode = node;
                continue block0;
            }
            junit.framework.Assert.fail((String)("Unable to find node " + nodeName + " inside " + currentNode.getName()));
        }
        currentNode.addChildren(wikitty.getId());
        this.ws.store(currentNode.getWikitty());
    }
}

