/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.test.api;

import junit.framework.Assert;
import org.junit.Test;
import org.sharengo.wikitty.ExtensionFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.test.api.AbstractTestApi;

public class ExtensionFactoryTest
extends AbstractTestApi {
    @Test
    public void testExtensionFactory() throws Exception {
        WikittyExtension ext = ExtensionFactory.create((String)"testExtension", (String)"1.0").addField("name", FieldType.TYPE.STRING).addField("phoneNumbers", FieldType.TYPE.STRING).minOccur(2).maxOccur(10).addField("matricule", FieldType.TYPE.NUMERIC).unique().addField("fired", FieldType.TYPE.BOOLEAN).extension();
        Assert.assertEquals((String)"testExtension", (String)ext.getName());
        Assert.assertEquals((String)"1.0", (String)ext.getVersion());
        this.checkField(ext, "name", FieldType.TYPE.STRING, 0, 1, false);
        this.checkField(ext, "phoneNumbers", FieldType.TYPE.STRING, 2, 10, false);
        this.checkField(ext, "matricule", FieldType.TYPE.NUMERIC, 0, 1, true);
        this.checkField(ext, "fired", FieldType.TYPE.BOOLEAN, 0, 1, false);
    }

    private void checkField(WikittyExtension ext, String fieldName, FieldType.TYPE type, int min, int max, boolean unique) {
        FieldType fieldType = ext.getFieldType(fieldName);
        String str = "Checking " + ext.getName() + "." + fieldName + " field...";
        Assert.assertNotNull((String)str, (Object)fieldType);
        Assert.assertEquals((String)str, (Object)type, (Object)fieldType.getType());
        Assert.assertEquals((String)str, (int)min, (int)fieldType.getLowerBound());
        Assert.assertEquals((String)str, (int)max, (int)fieldType.getUpperBound());
        Assert.assertEquals((String)str, (boolean)unique, (boolean)fieldType.isUnique());
    }
}

