/* *##%
 * Copyright (c) 2009 Sharengo, Guillaume Dufrene, Benjamin POUSSIN.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.Collections;

/**
 *
 * @author poussin
 * @version $Revision: 1 $
 *
 * Each business object will inherit of this class.
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class BusinessEntityWikitty implements BusinessEntity {

    private static final long serialVersionUID = 1L;

    protected Wikitty wikitty;

    public BusinessEntityWikitty(Wikitty wi) {
        setWikitty(wi);
    }

    public BusinessEntityWikitty() {
        setWikitty(new Wikitty());
    }
    
    public String getWikittyId() {
        String result = getWikitty().getId();
        return result;
    }

    public String getWikittyVersion() {
        String result = getWikitty().getVersion();
        return result;
    }

    public void setWikittyVersion(String version) {
        getWikitty().setVersion(version);
    }

    public void setWikitty(Wikitty wikitty) {
        if(wikitty != null) {
            for (WikittyExtension ext : getStaticExtensions()) {
                wikitty.addExtension(ext);
            }
        }
        this.wikitty = wikitty;
    }

    public Wikitty getWikitty() {
        return wikitty;
    }
    
    public Collection<String> getExtensionNames() {
        Collection<String> result = getWikitty().getExtensionNames();
        return result;
    }

    public Collection<String> getExtensionFields(String ext) {
        Collection<String> result = getWikitty().getExtension(ext).getFieldNames();
        return result;
    }

    public FieldType getFieldType(String ext, String fieldName) {
        FieldType result = getWikitty().getExtension(ext).getFieldType(fieldName);
        return result;
    }

    public Object getField(String ext, String fieldName) {
        Object result = getWikitty().getFieldAsObject(ext, fieldName);
        return result;
    }

    public void setField(String ext, String fieldName, Object value) {
        getWikitty().setField(ext, fieldName, value);
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return Collections.emptyList();
    }
}
