/*
 * #%L
 * Wikitty :: hessian client
 * 
 * $Id: WikittyServiceHessianClient.java 1581 2014-02-07 11:31:04Z tchemit $
 * $HeadURL: http://svn.nuiton.org/wikitty/tags/wikitty-3.11/wikitty-hessian-client/src/main/java/org/nuiton/wikitty/services/WikittyServiceHessianClient.java $
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.services;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.wikitty.hessian.WikittyHessianFactory;

/**
 *
 * @author poussin
 * @version $Revision: 1581 $
 *
 * Last update: $Date: 2014-02-07 12:31:04 +0100 (Fri, 07 Feb 2014) $
 * by : $Author: tchemit $
 */
public class WikittyServiceHessianClient extends WikittyServiceDelegator {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceHessianClient.class);

    public WikittyServiceHessianClient(ApplicationConfig config) {
        String url = config.getOption(WikittyConfigOption.
                WIKITTY_SERVER_URL.getKey());
        WikittyService ws = WikittyHessianFactory.getWikittyService(url);
        setDelegate(ws);
    }

}
