/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.filter;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;

public abstract class TopiaTransactionFilter
implements Filter {
    public static final String TOPIA_TRANSACTION_REQUEST_ATTRIBUTE = "topiaTransaction";
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"beginTransaction", "closeContext", "clear"};
    public static final String[] DEFAULT_UNUSED_METHODS = new String[]{"toString", "isClosed", "closeContext", "clear", "equals", "hashCode", "finalize", "getClass"};
    private static final Log log = LogFactory.getLog(TopiaTransactionFilter.class);
    protected Set<String> excludeMethods;
    protected Set<String> unusedMethods;

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public Set<String> getUnusedMethods() {
        return this.unusedMethods;
    }

    public static TopiaContext getTransaction(ServletRequest request) {
        TopiaContext topiaContext = (TopiaContext)request.getAttribute(TOPIA_TRANSACTION_REQUEST_ATTRIBUTE);
        return topiaContext;
    }

    protected abstract TopiaContext beginTransaction() throws TopiaRuntimeException;

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String methodsFromConfig = filterConfig.getInitParameter("execludeMethods");
        String[] methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_EXCLUDE_METHODS;
        this.excludeMethods = new HashSet<String>(Arrays.asList(methods));
        methodsFromConfig = filterConfig.getInitParameter("unusedMethods ");
        methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_UNUSED_METHODS;
        this.unusedMethods = new HashSet<String>(Arrays.asList(methods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TopiaTransactionProxyInvocationHandler proxyInvocationHandler = new TopiaTransactionProxyInvocationHandler();
        TopiaContext proxy = (TopiaContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TopiaContext.class, TopiaContextImplementor.class}, (InvocationHandler)proxyInvocationHandler);
        request.setAttribute(TOPIA_TRANSACTION_REQUEST_ATTRIBUTE, (Object)proxy);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.onCloseTransaction(proxyInvocationHandler.transaction);
        }
    }

    protected Object onExcludeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        throw new IllegalAccessException("Not allowed to access method " + method.getName() + " on " + proxy);
    }

    protected void onCloseTransaction(TopiaContext transaction) {
        if (transaction == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"no transaction to close");
            }
        } else if (transaction.isClosed()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("transaction " + transaction + " is already closed"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing transaction " + transaction));
            }
            try {
                Transaction tx = ((TopiaContextImplementor)transaction).getHibernate().getTransaction();
                if (!tx.wasCommitted() && !tx.wasRolledBack()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"rollback transaction!");
                    }
                    tx.rollback();
                }
                transaction.closeContext();
            }
            catch (TopiaException e) {
                throw new TopiaRuntimeException((Throwable)e);
            }
        }
    }

    protected Object onUnusedMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Set<String> methods;
        String methodName = method.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skip execution of method " + methodName + " since no transaction is instanciated."));
        }
        if ((methods = this.getUnusedMethods()).contains("toString")) {
            return "No transaction opened yet for this proxy";
        }
        if (methods.contains("isClosed")) {
            return false;
        }
        if (methods.contains("equals")) {
            return false;
        }
        if (methods.contains("hashCode")) {
            return 0;
        }
        if (methods.contains("getClass")) {
            return TopiaContext.class;
        }
        return null;
    }

    public class TopiaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected TopiaContext transaction;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (TopiaTransactionFilter.this.getExcludeMethods().contains(methodName)) {
                Object result = TopiaTransactionFilter.this.onExcludeMethod(proxy, method, args);
                return result;
            }
            if (this.transaction == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("transaction started due to a call to " + methodName));
                }
                if (TopiaTransactionFilter.this.getUnusedMethods().contains(methodName)) {
                    Object result = TopiaTransactionFilter.this.onUnusedMethod(proxy, method, args);
                    return result;
                }
                this.transaction = TopiaTransactionFilter.this.beginTransaction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Open transaction " + this.transaction));
                }
            }
            try {
                Object result = method.invoke((Object)this.transaction, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }
}

