/*
 * #%L
 * Nuiton Web :: Nuiton Web
 * 
 * $Id: RequestStatistics.java 152 2011-12-01 17:16:59Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.8/nuiton-web/src/main/java/org/nuiton/web/jmx/RequestStatistics.java $
 * %%
 * Copyright (C) 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.jmx;

import java.io.Serializable;

public class RequestStatistics implements Serializable {

    protected int count;

    protected long elapsedSum;

    protected long lowestElapsed = Long.MAX_VALUE;

    protected long highestElapsed;

    public int getCount() {
        return count;
    }

    public long getElapsedSum() {
        return elapsedSum;
    }

    public long getLowestElapsed() {
        return lowestElapsed;
    }

    public long getHighestElapsed() {
        return highestElapsed;
    }

    public long getAverageElapsed() {
        return elapsedSum / count;
    }

    public void count(long start, long stop) {
        count += 1;
        long elapsed = stop - start;
        elapsedSum += elapsed;
        if (elapsed < lowestElapsed) {
            lowestElapsed = elapsed;
        }
        if (elapsed > highestElapsed) {
            highestElapsed = elapsed;
        }
    }

    @Override
    public String toString() {
        return "count=" + count +
               ", elapsedSum=" + elapsedSum +
               ", lowestElapsed=" + lowestElapsed +
               ", highestElapsed=" + highestElapsed +
               ", averageElapsed=" + getAverageElapsed() +
               '}';
    }
}
