/*
 * #%L
 * Nuiton Web :: Nuiton Struts 2
 * 
 * $Id: BaseAction.java 69 2011-05-11 08:07:46Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-parent-1.1/nuiton-struts2/src/main/java/org/nuiton/web/struts2/BaseAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.struts2;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.util.ValueStack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Arrays;
import java.util.List;

/**
 * Base action to use for a better usage of I18n.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class BaseAction extends ActionSupport {

    private static final long serialVersionUID = 1L;

    public static final String UNTRANSLATED_MARKER = "???";

    private static final Log log = LogFactory.getLog(BaseAction.class);

    public String _(String aTextName) {
        String value = getText(aTextName);
        return value;
    }

    public String _(String key, Object... args) {
        String value = getText(key, Arrays.asList(args));
        return value;
    }

    @Override
    public String getText(String aTextName) {
        String value = super.getText(aTextName);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue) {
        String value = super.getText(aTextName, defaultValue);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue, String obj) {
        String value = super.getText(aTextName, defaultValue, obj);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, List<?> args) {
        String value = super.getText(aTextName, args);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String key, String[] args) {
        String value = super.getText(key, args);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue, List<?> args) {
        String value = super.getText(aTextName, defaultValue, args);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args) {
        String value = super.getText(key, defaultValue, args);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        String value = super.getText(key, defaultValue, args, stack);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        String value = super.getText(key, defaultValue, args, stack);
        return getSafeText(key, value);
    }

    protected String getSafeText(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            if (log.isWarnEnabled()) {
                log.warn("Key [" + key + "] is not translated");
            }
            return UNTRANSLATED_MARKER + key + UNTRANSLATED_MARKER;
        }
        return value;
    }

}
