/*
 * #%L
 * Nuiton Utils :: Nuiton RSS
 * 
 * $Id: HTMLScriptCleaner.java 46 2011-01-26 15:14:38Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.0/nuiton-rss/src/main/java/org/nuiton/rss/HTMLScriptCleaner.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.rss;

/**
 * Supprime les balises <script.*</script> de la chaine
 *
 * @author poussin
 */
public class HTMLScriptCleaner implements HTMLCleaner {

    public String clean(String s) {
        String result = s.replaceAll("(?i)(?s)<script.*?</script>", "");
        return result;
    }

}
