/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.templates.TopiaGeneratorUtil;

public class EntityTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityTransformer.class);
    protected ObjectModelInterface outputInterface;
    protected ObjectModelClass outputAbstract;
    protected ObjectModelClass outputImpl;
    private boolean associationClass;
    protected boolean generateInterface;
    protected boolean generateAbstract;
    protected boolean generateImpl;
    protected boolean generateBooleanGetMethods;
    private ObjectModelOperation acceptOperation;
    private StringBuilder acceptOperationBody;

    protected void clean() {
        this.outputInterface = null;
        this.outputAbstract = null;
        this.outputImpl = null;
    }

    public void transformFromClass(ObjectModelClass input) {
        String i18nPrefix;
        String prefix;
        if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)input)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + input.getQualifiedName()));
            log.debug((Object)("Will use classLoader " + this.getClassLoader()));
        }
        if (StringUtils.isEmpty((CharSequence)(prefix = this.getConstantPrefix((ObjectModelClassifier)input, ""))) && log.isWarnEnabled()) {
            log.warn((Object)("[" + input.getName() + "] Will generate constants with NO prefix, not a good idea... \n" + "Use '" + "constantPrefix" + "' tagvalue in your xmi properties. For example " + "for all the model : model.tagvalue." + "constantPrefix" + "=PROPERTY_"));
        }
        this.setConstantPrefix(prefix);
        this.generateInterface = this.isGenerateInterface(input);
        this.generateAbstract = this.isGenerateAbstract(input);
        this.generateImpl = this.isGenerateImpl(input);
        this.generateBooleanGetMethods = TopiaGeneratorUtil.isDoNotGenerateBooleanGetMethods((ObjectModel)((ObjectModel)this.model), (ObjectModelClassifier)input);
        if (this.generateInterface) {
            this.createEntityInterface(input);
        }
        if (this.generateAbstract) {
            this.createEntityAbstractClass(input);
        }
        if (!StringUtils.isEmpty((CharSequence)(i18nPrefix = TopiaGeneratorUtil.getI18nPrefixTagValue((ObjectModelElement)input, (ObjectModel)((ObjectModel)this.model))))) {
            this.generateI18nBlock((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputAbstract, i18nPrefix);
        }
        this.createAcceptOperation();
        this.generateProperties(input.getAttributes());
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass association = (ObjectModelAssociationClass)input;
            this.associationClass = true;
            this.generateProperties(association.getParticipantsAttributes());
            this.associationClass = false;
        }
        this.closeAcceptOperation();
        this.generateExtraConstants(input);
        this.generateExtraOperations(input);
        this.generateAggregateOperation(input);
        this.generateCompositeOperation(input);
        if (TopiaGeneratorUtil.generateToString(input, (ObjectModel)this.model)) {
            this.generateToStringOperation(input);
        }
        this.generateSerialVersionUID(input, this.outputAbstract);
        if (this.generateImpl) {
            this.generateImpl(input);
            this.generateSerialVersionUID(input, this.outputImpl);
        }
        this.clean();
    }

    protected void generateSerialVersionUID(ObjectModelClass input, ObjectModelClass ouput) {
        String svUID = TopiaGeneratorUtil.findTagValue((String)"serialVersionUID", (ObjectModelElement)input, (Model)this.model);
        if (svUID == null) {
            svUID = TopiaGeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)ouput) + "L";
        }
        this.addConstant((ObjectModelClassifier)ouput, "serialVersionUID", Long.TYPE, svUID, (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
    }

    protected void createEntityInterface(ObjectModelClass input) {
        this.outputInterface = this.createInterface(input.getName(), input.getPackageName());
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)input)) {
            this.setDocumentation((ObjectModelElement)this.outputInterface, input.getDocumentation());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will add interfaces on " + this.outputInterface.getQualifiedName()));
        }
        LinkedList<String> interfaceAlreadyDone = new LinkedList<String>();
        for (ObjectModelClassifier parent : input.getInterfaces()) {
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, parent);
        }
        boolean needTopiaEntity = true;
        for (ObjectModelClassifier parent : input.getSuperclasses()) {
            if (!TopiaGeneratorUtil.isEntity(parent)) continue;
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, parent);
            needTopiaEntity = false;
            break;
        }
        if (needTopiaEntity) {
            Class<TopiaEntity> interfaze = TopiaEntity.class;
            if (TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
                interfaze = TopiaEntityContextable.class;
            }
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, interfaze);
        } else if (TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, TopiaEntityContextable.class);
        }
    }

    protected void createEntityAbstractClass(ObjectModelClass input) {
        this.outputAbstract = this.createAbstractClass(input.getName() + "Abstract", input.getPackageName());
        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entit\u00e9 {@link ");
        doc.append(StringUtils.capitalize((String)this.outputInterface.getName()));
        doc.append("}\n");
        String dbName = TopiaGeneratorUtil.getDbName((ObjectModelElement)input);
        if (dbName != null) {
            doc.append("<p>Nom de l'entit\u00e9 en BD : ");
            doc.append(dbName);
            doc.append(".</p>");
        }
        this.setDocumentation((ObjectModelElement)this.outputAbstract, doc.toString());
        this.addInterface((ObjectModelClassifier)this.outputAbstract, this.outputInterface.getName());
        for (ObjectModelClass parent : input.getSuperclasses()) {
            String extendClass = TopiaGeneratorUtil.getDOType((ObjectModelElement)parent, (ObjectModel)this.model);
            this.setSuperClass(this.outputAbstract, extendClass);
        }
        if (this.outputAbstract.getSuperclasses().isEmpty()) {
            String superClassName = TopiaGeneratorUtil.getEntitySuperClassTagValue((ObjectModelClassifier)input, (ObjectModel)this.model);
            if (superClassName == null) {
                superClassName = TopiaEntityAbstract.class.getName();
            }
            this.setSuperClass(this.outputAbstract, superClassName);
        }
        this.addContextableMethods(input, this.outputAbstract);
    }

    protected void addContextableMethods(ObjectModelClass input, ObjectModelClass outputAbstract) {
        if (TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
            this.addImport((ObjectModelClassifier)outputAbstract, TopiaDaoSupplier.class);
            ObjectModelAttribute topiaContextAttribute = this.addAttribute((ObjectModelClassifier)outputAbstract, "topiaDaoSupplier", TopiaDaoSupplier.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.TRANSIENT});
            this.setDocumentation((ObjectModelElement)topiaContextAttribute, "TopiaDAO instance associated with the current \ninstance. For internal usage only");
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)outputAbstract, "getTopiaDAOSupplier", TopiaDaoSupplier.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.setDocumentation((ObjectModelElement)op, "@since 3.0");
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
            this.setOperationBody(op, "\n        return topiaDaoSupplier;\n    ");
            op = this.addOperation((ObjectModelClassifier)outputAbstract, "setTopiaDAOSupplier", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, TopiaDaoSupplier.class, "topiaDaoSupplier");
            this.setDocumentation((ObjectModelElement)op, "@since 3.0");
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
            this.setOperationBody(op, "\n        if (this.topiaDaoSupplier == null) {\n            this.topiaDaoSupplier = topiaDaoSupplier;\n//        } else {\n//            throw new TopiaException(\"TopiaContext replacement is forbidden\");\n        }\n    ");
            op = this.addOperation((ObjectModelClassifier)outputAbstract, "update", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
            this.setOperationBody(op, "\n        getTopiaDAOSupplier().getDao(" + input.getName() + ".class).update(this);\n" + "    ");
            op = this.addOperation((ObjectModelClassifier)outputAbstract, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
            this.setOperationBody(op, "\n        getTopiaDAOSupplier().getDao(" + input.getName() + ".class).delete(this);\n" + "    ");
        }
    }

    protected boolean isGenerateInterface(ObjectModelClass input) {
        boolean alreadyInClassPath = !this.isInClassPath((ObjectModelClassifier)input);
        return alreadyInClassPath;
    }

    protected boolean isGenerateAbstract(ObjectModelClass input) {
        String fqn = input.getQualifiedName() + " Abstract";
        boolean alreadyInClassPath = !this.isInClassPath(fqn);
        return alreadyInClassPath;
    }

    protected boolean isGenerateImpl(ObjectModelClass input) {
        Collection operations = input.getOperations();
        String fqn = input.getQualifiedName() + "Impl";
        boolean alreadyInClassPath = this.isInClassPath(fqn);
        if (alreadyInClassPath) {
            return false;
        }
        if (!operations.isEmpty()) {
            log.info((Object)("Will not generate [" + fqn + "], there is some operations to manually implement"));
            return false;
        }
        for (ObjectModelOperation otherOp : input.getAllOtherOperations(false)) {
            if (!otherOp.isAbstract()) continue;
            log.info((Object)("Will not generate [" + fqn + "], there is an abstract operation [" + otherOp.getName() + "] in allOtherOperations."));
            return false;
        }
        return true;
    }

    protected void generateImpl(ObjectModelClass input) {
        String implName = input.getName() + "Impl";
        String packageName = input.getPackageName();
        if (this.isVerbose()) {
            log.info((Object)("Will generate [" + implName + "]"));
        }
        this.outputImpl = this.isAbstract(input) ? this.createAbstractClass(implName, packageName) : this.createClass(implName, packageName);
        this.setDocumentation((ObjectModelElement)this.outputImpl, "Implantation des operations pour l'entit\u00e9 " + input.getName() + ".");
        this.setSuperClass(this.outputImpl, input.getQualifiedName() + "Abstract");
    }

    protected void generateExtraConstants(ObjectModelClass input) {
        Set constants = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputInterface);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add constants from dependency : " + constants));
        }
    }

    protected void generateExtraOperations(ObjectModelClass input) {
        for (ObjectModelOperation operation : input.getOperations()) {
            String opName = operation.getName();
            String opType = operation.getReturnType();
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Extra operation for : " + input.getQualifiedName() + " - method : " + opName + " - returnType : " + opType + " - visibility : " + visibility));
            }
            if (TopiaGeneratorUtil.hasDaoStereotype(operation)) {
                return;
            }
            if (!visibility.equals(ObjectModelJavaModifier.PUBLIC)) {
                this.addOperation((ObjectModelClassifier)this.outputAbstract, opName, opType, new ObjectModelModifier[]{visibility, ObjectModelJavaModifier.ABSTRACT});
                continue;
            }
            this.cloneOperationSignature(operation, (ObjectModelClassifier)this.outputInterface, true, new ObjectModelModifier[0]);
        }
    }

    protected void generateProperties(Collection<ObjectModelAttribute> attributes) {
        for (ObjectModelAttribute attribute : attributes) {
            if (!this.associationClass) {
                if (!attribute.isNavigable() && attribute.hasAssociationClass()) {
                    this.generatePropertyConstant(attribute);
                    this.generatePropertyAttribute(attribute);
                    this.updateAcceptOperation(attribute);
                }
                if (!attribute.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute.getReverseAttribute(), (ObjectModel)this.model)) continue;
            }
            this.generatePropertyConstant(attribute);
            this.generatePropertyAttribute(attribute);
            this.generatePropertyOperations(attribute);
            this.updateAcceptOperation(attribute);
        }
    }

    protected void generatePropertyConstant(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate constant for property : " + attrName));
        }
        this.addAttribute((ObjectModelClassifier)this.outputInterface, this.getConstantName(attrName), String.class, "\"" + attrName + "\"", new ObjectModelModifier[0]);
    }

    protected void generatePropertyAttribute(ObjectModelAttribute attribute) {
        String dbName;
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        String collectionType = this.getCollectionType(attribute);
        if (collectionType != null) {
            attrType = collectionType + "<" + attrType + ">";
        }
        ObjectModelAttribute property = this.addAttribute((ObjectModelClassifier)this.outputAbstract, attrName, attrType, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        StringBuilder buffer = new StringBuilder();
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            String attrDocumentation = attribute.getDocumentation();
            buffer.append(attrDocumentation).append('\n');
        }
        if (!StringUtils.isEmpty((CharSequence)(dbName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attribute)))) {
            buffer.append("Nom de l'attribut en BD : ").append(dbName).append('\n');
        }
        this.setDocumentation((ObjectModelElement)property, buffer.toString());
        String annotation = TopiaGeneratorUtil.getAnnotationTagValue(attribute);
        if (!StringUtils.isEmpty((CharSequence)annotation)) {
            this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)property, annotation);
        }
    }

    protected void generatePropertyOperations(ObjectModelAttribute attribute) {
        if (attribute.getMaxMultiplicity() == 1 || this.associationClass) {
            this.addSingleSetOperation(attribute);
            boolean booleanProperty = TopiaGeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attribute);
            String attrType = this.getPropertyType(attribute);
            if (booleanProperty) {
                this.addSingleGetOperation(attribute, attrType, "is");
            }
            if (!booleanProperty || this.generateBooleanGetMethods) {
                this.addSingleGetOperation(attribute, attrType, "get");
            }
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attribute);
            String collectionImpl = TopiaGeneratorUtil.getNMultiplicityObjectType(attribute);
            this.addImport((ObjectModelClassifier)this.outputInterface, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionImpl);
            collectionInterface = TopiaGeneratorUtil.getSimpleName((String)collectionInterface);
            collectionImpl = TopiaGeneratorUtil.getSimpleName((String)collectionImpl);
            this.addMultipleAddOperation(attribute, collectionImpl);
            this.addMultipleAddAllOperation(attribute, collectionInterface);
            this.addMultipleSetOperation(attribute, collectionInterface, collectionImpl);
            this.addMultipleRemoveOperation(attribute);
            this.addMultipleClearOperation(attribute, collectionInterface, collectionImpl);
            this.addMultipleGetOperation(attribute, collectionInterface);
            if (TopiaGeneratorUtil.isEntity(attribute, (ObjectModel)this.model)) {
                this.addMultipleGetByTopiaIdOperation(attribute);
                this.addMultipleGetTopiaIdsOperation(attribute, collectionInterface, collectionImpl);
            }
            if (attribute.hasAssociationClass()) {
                this.addMultipleGetOperationFromEntity(attribute);
            }
            this.addMultipleSizeOperation(attribute);
            this.addMultipleIsEmptyOperations(attribute);
        }
    }

    protected void addSingleSetOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single 'set' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, attrType, attrName, "");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        String constantName = this.getConstantName(attrName);
        this.setOperationBody(implOperation, "\n        " + attrType + " oldValue = this." + attrName + ";\n" + "        fireOnPreWrite(" + constantName + ", oldValue, " + attrName + ");\n" + "        this." + attrName + " = " + attrName + ";\n" + "        fireOnPostWrite(" + constantName + ", oldValue, " + attrName + ");\n" + "    ");
    }

    protected void addSingleGetOperation(ObjectModelAttribute attribute, String attrType, String operationPrefix) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single '" + operationPrefix + "' operation for property : " + attrName + " [" + attrType + "]"));
        }
        String constantName = this.getConstantName(attrName);
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName(operationPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        fireOnPreRead(" + constantName + ", " + attrName + ");\n" + "        " + attrType + " result = this." + attrName + ";\n" + "        fireOnPostRead(" + constantName + ", " + attrName + ");\n" + "        return result;\n" + "    ");
    }

    protected void addMultipleAddOperation(ObjectModelAttribute attribute, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'add' operation for property : " + attrName + " [" + attrType + "]"));
        }
        String constantName = this.getConstantName(attrName);
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("add", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        body.append("\n        fireOnPreWrite(" + constantName + ", null, " + attrName + ");\n" + "        if (this." + attrName + " == null) {\n" + "            this." + attrName + " = new " + collectionImpl + "<" + attrType + ">();\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            String reverseAttrType = TopiaGeneratorUtil.getSimpleName((String)reverse.getType());
            if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("\n        " + attrName + "." + setterName + "(this);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("\n        if (" + attrName + "." + getterName + "() == null) {\n" + "            " + attrName + "." + setterName + "(new " + collectionImpl + "<" + reverseAttrType + ">());\n" + "        }\n" + "        " + attrName + "." + getterName + "().add(this);\n" + "");
            }
        }
        body.append("\n        this." + attrName + ".add(" + attrName + ");\n" + "        fireOnPostWrite(" + constantName + ", this." + attrName + ".size(), null, " + attrName + ");\n" + "    ");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleAddAllOperation(ObjectModelAttribute attribute, String collectionInterface) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'addAll' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("addAll", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, collectionInterface + "<" + attrType + ">", attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        String addMethodName = this.getJavaBeanMethodName("add", attrName);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "        for (" + attrType + " item : " + attrName + ") {\n" + "            " + addMethodName + "(item);\n" + "        }\n" + "    ");
    }

    protected void addMultipleSetOperation(ObjectModelAttribute attribute, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String referenceType = this.getPropertyType(attribute);
        String attrType = collectionInterface + "<" + referenceType + ">";
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'set' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, attrType, attrName, "");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        referenceType = TopiaGeneratorUtil.getSimpleName((String)referenceType);
        this.setOperationBody(implOperation, "\n        // Copy elements to keep data for fire with new reference\n        " + attrType + " oldValue = this." + attrName + " != null ? new " + collectionImpl + "<" + referenceType + ">(this." + attrName + ") : null;\n" + "        fireOnPreWrite(" + constantName + ", oldValue, " + attrName + ");\n" + "        this." + attrName + " = " + attrName + ";\n" + "        fireOnPostWrite(" + constantName + ", oldValue, " + attrName + ");\n" + "    ");
    }

    protected void addMultipleRemoveOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate 'remove' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("remove", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        body.append("\n        fireOnPreWrite(" + constantName + ", " + attrName + ", null);\n" + "        if (this." + attrName + " == null || !this." + attrName + ".remove(" + attrName + ")) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("\n        " + attrName + "." + setterName + "(null);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("\n        " + attrName + "." + getterName + "().remove(this);\n" + "");
            }
        }
        body.append("\n        fireOnPostWrite(" + constantName + ", this." + attrName + ".size() + 1, " + attrName + ", null);\n" + "    ");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleClearOperation(ObjectModelAttribute attribute, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'clear' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("clear", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder("\n        if (this." + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            body.append("        for (" + attrType + " item : this." + attrName + ") {\n" + "");
            if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("            item." + setterName + "(null);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("            item." + getterName + "().remove(this);\n" + "");
            }
            body.append("        }\n");
        }
        body.append("        " + collectionInterface + "<" + attrType + "> oldValue = new " + collectionImpl + "<" + attrType + ">(this." + attrName + ");\n" + "        fireOnPreWrite(" + constantName + ", oldValue, this." + attrName + ");\n" + "        this." + attrName + ".clear();\n" + "        fireOnPostWrite(" + constantName + ", oldValue, this." + attrName + ");\n" + "    ");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleGetOperation(ObjectModelAttribute attribute, String collectionInterface) {
        String attrName = this.getPropertyName(attribute);
        String attrType = collectionInterface + "<" + this.getPropertyType(attribute) + ">";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'get' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        return " + attrName + ";\n" + "    ");
    }

    protected void addMultipleGetByTopiaIdOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getByTopiaId' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, String.class, "topiaId");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaEntityHelper.class);
        this.setOperationBody(implOperation, "\n        return TopiaEntityHelper.getEntityByTopiaId(" + attrName + ", topiaId);\n" + "    ");
    }

    protected void addMultipleGetTopiaIdsOperation(ObjectModelAttribute attribute, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        String getterName = this.getJavaBeanMethodName("get", attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getTopiaIds' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName) + "TopiaIds", collectionInterface + "<String>", new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        " + collectionInterface + "<String> topiaIds = new " + collectionImpl + "<String>();\n" + "        " + collectionInterface + "<" + attrType + "> tmp = " + getterName + "();\n" + "        if (tmp != null) {\n" + "            for (TopiaEntity topiaEntity : tmp) {\n" + "                topiaIds.add(topiaEntity.getTopiaId());\n" + "            }\n" + "        }\n" + "        return topiaIds;\n" + "    ");
    }

    protected void addMultipleGetOperationFromEntity(ObjectModelAttribute attribute) {
        String referenceName = attribute.getName();
        String referenceType = attribute.getType();
        String referenceGetterName = this.getJavaBeanMethodName("get", referenceName);
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getFromEntity' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[0]);
        this.addParameter(interfaceOperation, referenceType, referenceName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        if (" + referenceName + " == null || this." + attrName + " == null) {\n" + "            return null;\n" + "        }\n" + "        for (" + attrType + " item : this." + attrName + ") {\n" + "            if (" + referenceName + ".equals(item." + referenceGetterName + "())) {\n" + "                return item;\n" + "            }\n" + "        }\n" + "        return null;\n" + "    ");
    }

    protected void addMultipleSizeOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'size' operation for property : " + attrName));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("size", attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + attrName + ".size();\n" + "    ");
    }

    protected void addMultipleIsEmptyOperations(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'isEmpty' operation for property : " + attrName));
        }
        String sizeMethodName = this.getJavaBeanMethodName("size", attrName);
        String isEmptyMethodName = this.getJavaBeanMethodName("is", attrName) + "Empty";
        ObjectModelOperation isEmptyInterfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, isEmptyMethodName, Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation isEmptyOperationImpl = this.createImplOperation(isEmptyInterfaceOperation);
        this.setOperationBody(isEmptyOperationImpl, "\n        int size = " + sizeMethodName + "();\n" + "        return size == 0;\n" + "    ");
        ObjectModelOperation isNotEmptyInterfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("is", attrName) + "NotEmpty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation isNotEmptyOperationImpl = this.createImplOperation(isNotEmptyInterfaceOperation);
        this.setOperationBody(isNotEmptyOperationImpl, "\n        boolean empty = " + isEmptyMethodName + "();\n" + "        return ! empty;\n" + "    ");
    }

    protected void createAcceptOperation() {
        this.acceptOperation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "accept", Void.TYPE, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)this.acceptOperation, Override.class);
        ObjectModelParameter param = this.addParameter(this.acceptOperation, EntityVisitor.class, "visitor");
        this.addException(this.acceptOperation, TopiaException.class);
        this.acceptOperationBody = new StringBuilder("\n        visitor.start(this);\n");
    }

    protected void updateAcceptOperation(ObjectModelAttribute attribute) {
        String attrName = TopiaGeneratorUtil.getSimpleName((String)this.getPropertyName(attribute));
        String attrType = TopiaGeneratorUtil.getSimpleName((String)this.getPropertyType(attribute));
        String collectionType = this.getCollectionType(attribute);
        String constantName = this.getConstantName(attrName);
        if (collectionType != null) {
            collectionType = TopiaGeneratorUtil.getSimpleName((String)collectionType);
            this.acceptOperationBody.append("        visitor.visit(this, " + constantName + ", " + collectionType + ".class, " + attrType + ".class, " + attrName + ");\n" + "");
        } else {
            this.acceptOperationBody.append("        visitor.visit(this, " + constantName + ", " + attrType + ".class, " + attrName + ");\n" + "");
        }
    }

    protected void closeAcceptOperation() {
        this.acceptOperationBody.append("        visitor.end(this);\n    ");
        this.setOperationBody(this.acceptOperation, this.acceptOperationBody.length() == 0 ? " " : this.acceptOperationBody.toString());
    }

    protected void generateToStringOperation(ObjectModelClass input) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate toString method for entity " + this.outputInterface.getQualifiedName()));
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "toString", String.class, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class);
        this.addImport((ObjectModelClassifier)this.outputAbstract, ToStringBuilder.class);
        StringBuilder body = new StringBuilder("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && TopiaGeneratorUtil.isEntity(attrEntity);
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            String constantName = this.getConstantName(attrName);
            body.append("            append(" + constantName + ", this." + attrName + ").\n" + "");
        }
        body.append("         toString();\n        return result;\n    ");
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected void generateCompositeOperation(ObjectModelClass input) {
        StringBuilder body;
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "getComposite", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class);
        if (!TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
            body = new StringBuilder("\n        throw new UnsupportedOperationException(\"Since ToPIA 3.0, 'getComposite' is only available for contextable entities\");\n    ");
        } else {
            this.addImport((ObjectModelClassifier)this.outputAbstract, ArrayList.class);
            this.addImport((ObjectModelClassifier)this.outputAbstract, List.class);
            body = new StringBuilder("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
            for (ObjectModelAttribute attr : input.getAttributes()) {
                if (!attr.referenceClassifier() || !TopiaGeneratorUtil.isEntity(attr.getClassifier())) continue;
                if (attr.isComposite()) {
                    String attrName = attr.getName();
                    String getterName = this.getJavaBeanMethodName("get", attrName);
                    if (TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                        body.append("        if (" + getterName + "() != null) {\n" + "              tmp.addAll(" + getterName + "());\n" + "           }\n" + "");
                        continue;
                    }
                    body.append("        tmp.add(" + getterName + "());\n" + "");
                    continue;
                }
                if (!attr.hasAssociationClass()) continue;
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr.getAssociationClass().getQualifiedName());
                String ref = "this." + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("\n        if (" + ref + " != null) {\n" + "            tmp.add(" + ref + ");\n" + "        }\n" + "");
                    continue;
                }
                ObjectModelAttribute reverse = attr.getReverseAttribute();
                String reverseAttrName = reverse.getName();
                body.append("\n        {\n            org.nuiton.topia.persistence.TopiaDAO<" + assocClassFQN + "> dao = getTopiaContext().getDao(" + assocClassFQN + ".class);\n" + "            List<" + assocClassFQN + "> findAllByProperties = dao.findAllByProperties(\"" + reverseAttrName + "\", this);\n" + "            if (findAllByProperties != null) {\n" + "                tmp.addAll(findAllByProperties);\n" + "            }\n" + "        }\n" + "");
            }
            body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            if (entity != null) {\n                result.add(entity);\n                result.addAll(entity.getComposite());\n            }\n        }\n        return result;\n    ");
        }
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAggregateOperation(ObjectModelClass input) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "getAggregate", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class);
        StringBuilder body = new StringBuilder();
        if (!TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
            body = new StringBuilder("\n        throw new UnsupportedOperationException(\"Since ToPIA 3.0, 'getComposite' is only available for contextable entities\");\n    ");
        } else {
            this.addImport((ObjectModelClassifier)this.outputAbstract, ArrayList.class);
            this.addImport((ObjectModelClassifier)this.outputAbstract, List.class);
            body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
            for (ObjectModelAttribute attr : input.getAttributes()) {
                if (!attr.referenceClassifier() || !TopiaGeneratorUtil.isEntity(attr.getClassifier()) || !attr.isAggregate()) continue;
                String attrName = attr.getName();
                String getterName = this.getJavaBeanMethodName("get", attrName);
                if (TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("        tmp.addAll(" + getterName + "());\n" + "");
                    continue;
                }
                body.append("        tmp.add(" + getterName + "());\n" + "");
            }
            body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            result.add(entity);\n            result.addAll(entity.getAggregate());\n        }\n        return result;\n    ");
        }
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        Collection allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                ObjectModelOperation matchingOp;
                Iterator i$ = superClazz.getOperations(op.getName()).iterator();
                while (i$.hasNext() && !(implementationFound = op.equals(matchingOp = (ObjectModelOperation)i$.next()) && !matchingOp.isAbstract())) {
                }
                if (!implementationFound) continue;
                break;
            }
            if (implementationFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(clazz.getName() + " : abstract operation " + op));
            }
            return true;
        }
        return false;
    }

    protected String getCollectionType(ObjectModelAttribute attribute) {
        String result = null;
        if (!this.associationClass && TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute)) {
            result = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attribute);
        }
        return result;
    }

    protected String getPropertyName(ObjectModelAttribute attribute) {
        String propertyName = attribute.getName();
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attribute);
        }
        return propertyName;
    }

    protected String getPropertyType(ObjectModelAttribute attribute) {
        String propertyType = attribute.getType();
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyType = attribute.getAssociationClass().getQualifiedName();
        }
        return propertyType;
    }

    protected ObjectModelOperation createImplOperation(ObjectModelOperation interfaceOperation) {
        ObjectModelOperation implOperation = this.cloneOperationSignature(interfaceOperation, (ObjectModelClassifier)this.outputAbstract, false, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)implOperation, Override.class);
        return implOperation;
    }

    protected ObjectModelOperation createPropertySetterSignature(ObjectModelClassifier classifier, String propertyType, String propertyName, String operationDocumentation) {
        ObjectModelOperation operation = this.addOperation(classifier, this.getJavaBeanMethodName("set", propertyName), Void.TYPE, new ObjectModelModifier[0]);
        ObjectModelParameter param = this.addParameter(operation, propertyType, propertyName);
        if (StringUtils.isNotEmpty((CharSequence)operationDocumentation)) {
            this.setDocumentation((ObjectModelElement)operation, operationDocumentation);
            this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut \u00e0 positionner.");
        }
        return operation;
    }

    protected void addInterface(List<String> interfaceAlreadyDone, ObjectModelClassifier output, ObjectModelClassifier interfaze) {
        String qualifiedName = interfaze.getQualifiedName();
        if (!interfaceAlreadyDone.contains(qualifiedName)) {
            interfaceAlreadyDone.add(qualifiedName);
            if (output != null) {
                this.addInterface(output, qualifiedName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Add interface " + qualifiedName + " on " + output.getQualifiedName()));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Skip included interface " + qualifiedName));
            }
            for (ObjectModelClassifier parent : interfaze.getInterfaces()) {
                this.addInterface(interfaceAlreadyDone, null, parent);
            }
        }
    }

    protected void addInterface(List<String> interfaceAlreadyDone, ObjectModelClassifier output, Class<?> clazz) {
        String qualifiedName = clazz.getName();
        if (!interfaceAlreadyDone.contains(qualifiedName)) {
            this.addInterface(output, qualifiedName);
        }
    }
}

