/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.HibernateTopiaJpaSupport;
import org.nuiton.topia.TopiaHibernateSupport;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.templates.TopiaGeneratorUtil;

public class EntityDaoTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityDaoTransformer.class);
    protected Map<ObjectModelClass, Set<ObjectModelClass>> usages;
    protected Set<String> allEntitiesFqn;
    protected Class<?> daoImplementation;
    protected String entityEnumName;
    protected String entityEnumPackage;
    protected Map<String, Collection<ObjectModelOperation>> extraOperations = new HashMap<String, Collection<ObjectModelOperation>>();

    public void transformFromModel(ObjectModel model) {
        String modelName = model.getName();
        this.entityEnumName = modelName + "EntityEnum";
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        this.entityEnumPackage = packageName + "." + this.entityEnumName;
        this.usages = TopiaGeneratorUtil.searchDirectUsages(model);
        this.daoImplementation = TopiaGeneratorUtil.getDAOImplementation(model);
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses(model, true);
        this.allEntitiesFqn = new HashSet<String>(allEntities.size());
        for (ObjectModelClass entity : allEntities) {
            String fqn = entity.getQualifiedName();
            this.allEntitiesFqn.add(fqn);
            HashSet<ObjectModelOperation> daoOperations = new HashSet<ObjectModelOperation>();
            for (ObjectModelOperation op : entity.getOperations()) {
                if (!TopiaGeneratorUtil.hasDaoStereotype(op)) continue;
                daoOperations.add(op);
            }
            if (!daoOperations.isEmpty()) continue;
            this.extraOperations.put(fqn, daoOperations);
        }
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!TopiaGeneratorUtil.hasDaoStereotype((ObjectModelClassifier)interfacez)) {
            return;
        }
        ObjectModelDependency dependency = interfacez.getDependency("dao");
        if (dependency == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find dependency dao but DAO stereotype was placed on the interface " + interfacez.getName()));
            }
            return;
        }
        ObjectModelClassifier classifier = dependency.getSupplier();
        if (!TopiaGeneratorUtil.isEntity(classifier)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Dependency supplier " + classifier.getQualifiedName() + " is not an entity."));
            }
            return;
        }
        Collection operations = interfacez.getOperations();
        if (CollectionUtils.isEmpty((Collection)operations)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No operation found on interface with DAO stereotype " + classifier.getQualifiedName()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("add " + operations.size() + " extra operation(s) for DAO"));
        }
        this.extraOperations.put(classifier.getQualifiedName(), operations);
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        if (this.isGenerateGeneratedDao(clazz)) {
            this.generateGeneratedDao(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateAbstractDao(clazz)) {
            this.generateAbstractDao(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateConcreteDao(clazz)) {
            this.generateConcreteDao(clazz, clazzName, clazzFQN);
        }
    }

    protected boolean isGenerateConcreteDao(ObjectModelClass input) {
        String daoConcreteFqn = TopiaGeneratorUtil.getConcreteDaoFqn(input);
        return !this.isInClassPath(daoConcreteFqn);
    }

    protected boolean isGenerateGeneratedDao(ObjectModelClass input) {
        String daoGeneratedFqn = TopiaGeneratorUtil.getGeneratedDaoFqn(input);
        return !this.isInClassPath(daoGeneratedFqn);
    }

    protected boolean isGenerateAbstractDao(ObjectModelClass input) {
        String fqn = TopiaGeneratorUtil.getAbstractDaoFqn(input);
        if (this.isInClassPath(fqn)) {
            return false;
        }
        Collection<ObjectModelOperation> moreOperations = this.extraOperations.get(input.getQualifiedName());
        return !CollectionUtils.isNotEmpty(moreOperations);
    }

    protected void generateConcreteDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        String concreteDaoName = TopiaGeneratorUtil.getConcreteDaoName(clazz);
        ObjectModelClass daoClass = this.createClass(concreteDaoName, clazz.getPackageName());
        this.setDocumentation((ObjectModelElement)daoClass, "/**\n * Cette classe etend le DAOImpl pour parametrer la classe avec le bon type\n * Cette classe est marque finale car l'heritage entre les DAO se fait\n * sur les DOAImpl, c-a-d que DAOAbstract peut etendre le DAOImpl\n */");
        String superclassQualifiedName = TopiaGeneratorUtil.getAbstractDaoFqn(clazz) + "<" + clazzName + ">";
        this.setSuperClass(daoClass, superclassQualifiedName);
        String legacyConcreteDaoName = TopiaGeneratorUtil.getLegacyDaoName(clazz);
        this.warnOnLegacyClassDetected(clazz.getPackageName(), legacyConcreteDaoName, concreteDaoName, null, TopiaGeneratorUtil.getAbstractDaoFqn(clazz) + "<" + clazzName + ">");
    }

    protected void generateAbstractDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        Collection<ObjectModelOperation> moreOperations = this.extraOperations.get(clazz.getQualifiedName());
        if (CollectionUtils.isEmpty(moreOperations)) {
            String abstractDaoName = TopiaGeneratorUtil.getAbstractDaoName(clazz);
            String daoGenerics = "<E extends " + clazzName + ">";
            ObjectModelClass abstractDaoClass = this.createClass(abstractDaoName + daoGenerics, clazz.getPackageName());
            String documentation = String.format("/**%n * Implantation du Dao pour l'entit\u00e9 '%s'.%n * L'utilisateur peut remplacer cette classe par la sienne en la mettant%n * simplement dans ses sources. Cette classe g\u00e9n\u00e9r\u00e9e sera alors simplement%n * ignor\u00e9e \u00e0 la g\u00e9n\u00e9ration suivante.%n */", clazzName);
            this.setDocumentation((ObjectModelElement)abstractDaoClass, documentation);
            String superclassQualifiedName = TopiaGeneratorUtil.getGeneratedDaoFqn(clazz) + "<E>";
            this.setSuperClass(abstractDaoClass, superclassQualifiedName);
            String legacyDaoImplName = TopiaGeneratorUtil.getLegacyDaoName(clazz) + "Impl";
            this.warnOnLegacyClassDetected(clazz.getPackageName(), legacyDaoImplName, abstractDaoName, daoGenerics, superclassQualifiedName);
        }
    }

    protected void warnOnLegacyClassDetected(String packageName, String legacyDaoName, String daoName, String daoGenerics, String superclassQualifiedName) {
        String legacyDaoFqn = String.format("%s.%s", packageName, legacyDaoName);
        if (log.isWarnEnabled() && this.getFileInClassPath(legacyDaoFqn) != null) {
            String format = "public class %s%s extends %s {";
            String superclassName = superclassQualifiedName.substring(superclassQualifiedName.lastIndexOf(46) + 1);
            String daoDeclaration = String.format(format, daoName, Strings.nullToEmpty((String)daoGenerics), superclassName);
            String warnMessage = "Legacy DAO detected : %s !%n - You should consider renaming '%s' to '%s'%n - Expected class declaration is : %s%n%n";
            log.warn((Object)String.format(warnMessage, legacyDaoFqn, legacyDaoName, daoName, daoDeclaration));
        }
    }

    protected void generateGeneratedDao(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        ObjectModelClass daoAbstractClass = this.createAbstractClass(TopiaGeneratorUtil.getGeneratedDaoName(clazz) + "<E extends " + clazzName + '>', clazz.getPackageName());
        String superClassName = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)parent)) continue;
            superClassName = TopiaGeneratorUtil.getAbstractDaoFqn(parent) + "<E>";
            break;
        }
        if (superClassName == null) {
            superClassName = this.daoImplementation.getName() + "<E>";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("super class = " + superClassName));
        }
        this.setSuperClass(daoAbstractClass, superClassName);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz, "");
        this.setConstantPrefix(prefix);
        Collection<ObjectModelOperation> daoOperations = this.getDaoOperations(clazz);
        if (TopiaGeneratorUtil.isCollectionNeeded(daoOperations)) {
            this.addImport((ObjectModelClassifier)daoAbstractClass, Collection.class);
        }
        if (TopiaGeneratorUtil.isSetNeeded(daoOperations)) {
            this.addImport((ObjectModelClassifier)daoAbstractClass, Set.class);
        }
        this.addImport((ObjectModelClassifier)daoAbstractClass, List.class);
        this.addImport((ObjectModelClassifier)daoAbstractClass, TopiaQueryBuilderAddCriteriaOrRunQueryStep.class);
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getEntityClass", "Class<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return (Class<E>) " + clazzName + ".class;\n" + "    ");
        this.addImport((ObjectModelClassifier)daoAbstractClass, this.entityEnumPackage);
        op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getTopiaEntityEnum", this.entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return " + this.entityEnumName + "." + clazzName + ";\n" + "    ");
        this.generateDAOOperations(daoAbstractClass, daoOperations);
        this.generateDelete(clazz, daoAbstractClass);
        this.generateNaturalId(daoAbstractClass, clazz);
        this.generateNotNull(daoAbstractClass, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, false);
                continue;
            }
            this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, true);
                    continue;
                }
                this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
            }
        }
        Set<ObjectModelClass> usagesForclass = this.usages.get(clazz);
        this.generateFindUsages(clazz, daoAbstractClass, usagesForclass);
    }

    protected void generateDelete(ObjectModelClass clazz, ObjectModelClass result) {
        StringBuilder body = new StringBuilder();
        String modelName = StringUtils.capitalize((String)((ObjectModel)this.model).getName());
        String providerFQN = this.getOutputProperties().getProperty("defaultPackage") + '.' + modelName + "DAOHelper.getImplementationClass";
        body.append("\n        if ( ! entity.isPersisted()) {\n            throw new IllegalArgumentException(\"entity \" + entity  + \" is not persisted, you can't delete it\");\n        }\n");
        boolean hibernateSupportGenerated = false;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrType = GeneratorUtil.getSimpleName((String)attr.getType());
            String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (attr.hasAssociationClass() || reverse == null || !reverse.isNavigable()) continue;
            if (!this.allEntitiesFqn.contains(attr.getType())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[" + result.getName() + "] Skip attribute [" + attr.getName() + "] with type " + attr.getType()));
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                String attrDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
                String attrClassifierDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr.getClassifier());
                String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
                String attrReverseDBName = TopiaGeneratorUtil.getReverseDbName(attr);
                if (!hibernateSupportGenerated) {
                    hibernateSupportGenerated = true;
                    this.addImport((ObjectModelClassifier)result, TopiaHibernateSupport.class);
                    this.addImport((ObjectModelClassifier)result, HibernateTopiaJpaSupport.class);
                    this.addImport((ObjectModelClassifier)result, Session.class);
                    body.append("\n        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();\n        Session hibernateSession = hibernateSupport.getHibernateSession();\n");
                }
                String removeName = this.getJavaBeanMethodName("remove", reverseAttrName);
                body.append("\n        {\n            String sql = \"SELECT main.topiaid \" +\n                    \" FROM " + attrClassifierDBName + " main, " + attrJoinTableName + " secondary \" +\n" + "                    \" WHERE main.topiaid=secondary." + attrDBName + " \" +\n" + "                    \" AND secondary." + attrReverseDBName + "='\" + entity.getTopiaId() + \"'\";\n" + "            List<" + attrType + "> list = hibernateSession\n" + "                    .createSQLQuery(sql)\n" + "                    .addEntity(\"main\", " + this.entityEnumName + "." + attrType + ".getImplementation())\n" + "                    .list();\n" + "\n" + "            for (" + attrType + " item : list) {\n" + "                item." + removeName + "(entity);\n" + "            }\n" + "        }\n" + "");
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) continue;
            this.addImport((ObjectModelClassifier)result, attrType);
            this.addImport((ObjectModelClassifier)result, attr.getType() + "TopiaDao");
            String attrSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)attrType);
            String attrConcreteDaoClassName = attrSimpleType + "TopiaDao";
            String getName = this.getJavaBeanMethodName("get", reverseAttrName);
            String setName = this.getJavaBeanMethodName("set", reverseAttrName);
            body.append("\n        {\n            " + attrConcreteDaoClassName + " dao = topiaDaoSupplier\n" + "                    .getDao(" + attrSimpleType + ".class, " + attrConcreteDaoClassName + ".class);\n" + "            List<" + attrSimpleType + "> list = dao\n" + "                    .forProperties(" + attrSimpleType + "." + this.getConstantName(reverseAttrName) + ", entity)\n" + "                    .findAll();\n" + "            for (" + attrSimpleType + " item : list) {\n" + "\n" + "                // sletellier : Set null only if target is concerned by deletion\n" + "                if (entity.equals(item." + getName + "())) {\n" + "                    item." + setName + "(null);\n" + "                }\n" + "            ");
            if (attr.isAggregate()) {
                body.append("\n            topiaDaoSupplier.getDao(" + attrSimpleType + ".class).delete(item);\n" + "");
            }
            body.append("\n            }\n        }\n");
        }
        if (body.length() > 0) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Override.class);
            this.addParameter(op, "E", "entity");
            body.append("\n        super.delete(entity);\n    ");
            this.setOperationBody(op, body.toString());
        }
    }

    protected void generateFindUsages(ObjectModelClass clazz, ObjectModelClass result, Set<ObjectModelClass> usagesForclass) {
        this.builder.addImport((ObjectModelClassifier)result, LinkedList.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, Map.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, HashMap.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, TopiaEntity.class.getName());
        if (clazz instanceof ObjectModelAssociationClass || usagesForclass.isEmpty()) {
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Class<U>", "type");
            this.addParameter(operation, "E", "entity");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
            this.setOperationBody(operation, "\n        return new LinkedList<U>();\n    ");
            operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "E", "entity");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
            this.setOperationBody(operation, "\n        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();\n    ");
            return;
        }
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        for (ObjectModelClass klass : allEntities) {
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "Class<U>", "type");
        this.addParameter(operation, "E", "entity");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("\n        List<?> result = new LinkedList();\n        List tmp;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String usageType = usageClass.getQualifiedName();
            this.builder.addImport((ObjectModelClassifier)result, usageType);
            this.builder.addImport((ObjectModelClassifier)result, TopiaGeneratorUtil.getConcreteDaoFqn(usageClass));
            String usageSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)usageType);
            String usageSimplePropertyMethod = "findAllBy" + usageSimpleType;
            String usageCollectionPropertyMethod = "findAllContaining" + usageSimpleType;
            for (ObjectModelAttribute attr : usageClass.getAttributes()) {
                ObjectModelClass targetEntity;
                String type;
                if (!attr.isNavigable()) continue;
                String attrName = attr.getName();
                if (attr.hasAssociationClass() || !allEntitiesByFQN.containsKey(type = attr.getType()) || !(targetEntity = (ObjectModelClass)allEntitiesByFQN.get(type)).equals(clazz)) continue;
                String methodName = TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? this.getJavaBeanMethodName("for", attrName, "Contains") : this.getJavaBeanMethodName("for", attrName, "Equals");
                String daoName = TopiaGeneratorUtil.getConcreteDaoName(usageClass);
                this.builder.addImport((ObjectModelClassifier)result, usageClass.getPackageName() + '.' + daoName);
                buffer.append("\n        if (type == " + usageSimpleType + ".class) {\n" + "            " + daoName + " dao =\n" + "                topiaDaoSupplier.getDao(" + usageSimpleType + ".class, " + daoName + ".class);\n" + "            tmp = dao." + methodName + "(entity).findAll();\n" + "            result.addAll(tmp);\n" + "        }\n" + "");
            }
        }
        buffer.append("\n        return (List<U>) result;\n    ");
        this.setOperationBody(operation, buffer.toString());
        operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "E", "entity");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, Override.class);
        buffer = new StringBuilder(300);
        buffer.append("\n        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;\n        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(" + usagesForclass.size() + ");\n" + "\n" + "        List<? extends TopiaEntity> list;\n" + "");
        for (ObjectModelClass usageClass : usagesForclass) {
            String fqn = usageClass.getName();
            buffer.append("\n        list = findUsages(" + fqn + ".class, entity);\n" + "        if (!list.isEmpty()) {\n" + "            result.put(" + fqn + ".class, list);\n" + "        }\n" + "");
        }
        buffer.append("\n        return result;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    @Deprecated
    protected void generateDAOOperations(ObjectModelClass result, Collection<ObjectModelOperation> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        for (ObjectModelOperation op : operations) {
            Set exceptions = op.getExceptions();
            this.cloneOperation(op, (ObjectModelClassifier)result, true, new ObjectModelJavaModifier[]{ObjectModelJavaModifier.ABSTRACT, ObjectModelJavaModifier.fromVisibility((String)op.getVisibility())});
        }
    }

    protected void generateNoNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr, boolean isAssoc) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = clazzName + "." + this.getConstantName(attrName);
        String attrTypeForGeneric = JavaGeneratorUtil.isPrimitiveType((String)attrType) ? TopiaGeneratorUtil.getClassForPrimitiveType(attr) : attrType;
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            propertyName = clazzName + '.' + this.getConstantName(assocAttrName) + " + '.' + " + assocClassName + '.' + this.getConstantName(attrName);
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "In"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, "Iterable<" + attrTypeForGeneric + ">", "v");
        this.setOperationBody(op, "\n        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(" + propertyName + ", (Iterable) v);\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "Equals"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(" + propertyName + ", v);\n" + "        return result;\n" + "    ");
        String methodToDelegateName = op.getName();
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAnyOrNull();\n" + "    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAll();\n" + "    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocPropertyConstantName = this.getConstantName(assocAttrName);
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", assocClassName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        E result = findByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n" + "        return result;\n" + "    ");
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", assocClassName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        List<E> result = findAllByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n" + "        return result;\n" + "    ");
        }
    }

    protected void generateNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            return;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("for", attrName, "Contains"), "TopiaQueryBuilderAddCriteriaOrRunQueryStep<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return forContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n" + "    ");
        String methodToDelegateName = op.getName();
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findContains", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAnyOrNull();\n" + "    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllContains", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        return " + methodToDelegateName + "(v).findAll();\n" + "    ");
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Deprecated.class);
    }

    @Deprecated
    public Collection<ObjectModelOperation> getDaoOperations(ObjectModelClass clazz) {
        Collection<ObjectModelOperation> extra = this.extraOperations.get(clazz.getQualifiedName());
        if (extra != null && !extra.isEmpty() && log.isWarnEnabled()) {
            log.warn((Object)"Dao contract in model will not be supported in topia 3.0");
        }
        return extra;
    }

    private void generateNaturalId(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = TopiaGeneratorUtil.getNaturalIdAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNaturalId for " + props));
            }
            ObjectModelOperation findByNaturalId = this.addOperation((ObjectModelClassifier)result, "findByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            ObjectModelOperation existByNaturalId = this.addOperation((ObjectModelClassifier)result, "existByNaturalId", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            ObjectModelOperation createByNaturalId = this.addOperation((ObjectModelClassifier)result, "createByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            LinkedHashSet properties = Sets.newLinkedHashSet();
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                String type = attr.getType();
                this.addParameter(findByNaturalId, type, propName);
                this.addParameter(existByNaturalId, type, propName);
                this.addParameter(createByNaturalId, type, propName);
                String property = clazzName + '.' + this.getConstantName(propName) + ", " + propName;
                properties.add(property);
            }
            String arguments = StringUtils.join((Iterable)properties, (String)", ");
            this.setOperationBody(findByNaturalId, "\n        return forProperties(" + arguments + ").findUnique();\n" + "    ");
            this.setOperationBody(existByNaturalId, "\n        return forProperties(" + arguments + ").exists();\n" + "    ");
            this.setOperationBody(createByNaturalId, "\n        return create(" + arguments + ");\n" + "    ");
        }
    }

    protected void generateNotNull(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = TopiaGeneratorUtil.getNotNullAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNotNull for " + props));
            }
            ObjectModelOperation createByNotNull = this.addOperation((ObjectModelClassifier)result, "createByNotNull", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            String createProperties = "";
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                this.addParameter(createByNotNull, attr.getType(), propName);
                createProperties = createProperties + ", " + clazzName + '.' + this.getConstantName(propName) + ", " + propName;
            }
            createProperties = createProperties.substring(2);
            this.setOperationBody(createByNotNull, "\n        return create(" + createProperties + ");\n" + "    ");
        }
    }
}

