/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.templates.TopiaGeneratorUtil;

public class DAOHelperTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(DAOHelperTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String packageName = this.getOutputProperties().getProperty("defaultPackage");
        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String entityEnumName = modelName + "EntityEnum";
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldGenerateOperatorForDAOHelper(model);
        ObjectModelClass daoHelper = this.createClass(daoHelperClazzName, packageName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will generate standalone " + entityEnumName + " in package " + packageName));
        }
        ObjectModelEnumeration entityEnum = this.createEnumeration(entityEnumName, packageName);
        this.addImport((ObjectModelClassifier)entityEnum, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)entityEnum, EntityOperatorStore.class);
        this.addImport((ObjectModelClassifier)entityEnum, Arrays.class);
        this.addImport((ObjectModelClassifier)entityEnum, ArrayUtils.class);
        this.createDAOHelper(model, daoHelper, daoHelperClazzName, entityEnumName, generateOperator, classes);
        this.createEntityEnum(entityEnum, daoHelperClazzName, entityEnumName, generateOperator, classes);
    }

    protected void createDAOHelper(ObjectModel model, ObjectModelClass daoHelper, String daoHelperClazzName, String entityEnumName, boolean generateOperator, List<ObjectModelClass> classes) {
        String modelName = model.getName();
        String modelVersion = model.getVersion();
        this.addImport((ObjectModelClassifier)daoHelper, TopiaDao.class);
        this.addImport((ObjectModelClassifier)daoHelper, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)daoHelper, TopiaDaoSupplier.class);
        this.addImport((ObjectModelClassifier)daoHelper, Array.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)daoHelper, EntityOperator.class);
            this.addImport((ObjectModelClassifier)daoHelper, EntityOperatorStore.class);
        }
        this.addAnnotation((ObjectModelClassifier)daoHelper, (ObjectModelElement)daoHelper, Deprecated.class);
        ObjectModelOperation constructor = this.addConstructor(daoHelper, (ObjectModelModifier)ObjectModelJavaModifier.PROTECTED);
        this.setOperationBody(constructor, " ");
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)daoHelper, "getModelVersion", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return \"" + modelVersion + "\";\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getModelName", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return \"" + modelName + "\";\n" + "    ");
        for (ObjectModelClass clazz : classes) {
            String className = clazz.getName();
            String concreteDaoClassName = TopiaGeneratorUtil.getConcreteDaoName(clazz);
            String concreteDaoFqn = TopiaGeneratorUtil.getConcreteDaoFqn(clazz);
            String methodName = "get" + concreteDaoClassName;
            op = this.addOperation((ObjectModelClassifier)daoHelper, methodName, concreteDaoFqn, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
            this.addParameter(op, TopiaDaoSupplier.class, "supplier");
            this.addImport((ObjectModelClassifier)daoHelper, clazz);
            this.addException(op, TopiaException.class);
            this.setOperationBody(op, "\n        " + concreteDaoClassName + " result = supplier.getDao(" + className + ".class, " + concreteDaoClassName + ".class);\n" + "        return result;\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getDao", "<T extends TopiaEntity, D extends TopiaDao<? super T>> D", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, TopiaDaoSupplier.class, "daoSupplier");
        this.addParameter(op, "Class<T>", "klass");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        D dao = (D) daoSupplier.getDao(constant.getContract());\n" + "        return dao;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getDao", "<T extends TopiaEntity, D extends TopiaDao<? super T>> D", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, TopiaDaoSupplier.class, "daoSupplier");
        this.addParameter(op, "T", "entity");
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(entity);\n" + "        D dao = (D) daoSupplier.getDao(constant.getContract());\n" + "        return dao;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getContract();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getImplementation();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getContract();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getImplementation();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getImplementationClassesAsString", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        StringBuilder buffer = new StringBuilder();\n        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {\n            buffer.append(',').append(aClass.getName());\n        }\n        return buffer.substring(1);\n    ");
        op = this.addOperation((ObjectModelClassifier)daoHelper, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return " + entityEnumName + ".values();\n" + "    ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)daoHelper, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return EntityOperatorStore.getOperator(constant);\n" + "    ");
        }
    }

    protected void createEntityEnum(ObjectModelEnumeration entityEnum, String daoHelperClazzName, String entityEnumName, boolean generateOperator, List<ObjectModelClass> classes) {
        this.addInterface((ObjectModelClassifier)entityEnum, TopiaEntityEnum.class);
        for (ObjectModelClass clazz : classes) {
            String clazzName = clazz.getName();
            boolean withNatural = false;
            boolean withNotNull = false;
            StringBuilder naturalIdsParams = new StringBuilder();
            StringBuilder notNullParams = new StringBuilder();
            Set<ObjectModelAttribute> naturalIdsAttributes = TopiaGeneratorUtil.getNaturalIdAttributes(clazz);
            for (ObjectModelAttribute attribute : naturalIdsAttributes) {
                withNatural = true;
                naturalIdsParams.append(", \"").append(attribute.getName()).append("\"");
            }
            Set<ObjectModelAttribute> notNullIdsAttributes = TopiaGeneratorUtil.getNotNullAttributes(clazz);
            for (ObjectModelAttribute attribute : notNullIdsAttributes) {
                withNotNull = true;
                notNullParams.append(", \"").append(attribute.getName()).append("\"");
            }
            StringBuilder params = new StringBuilder(clazzName + ".class");
            if (withNotNull) {
                params.append(", new String[]{ " + notNullParams.substring(2) + " }");
            } else {
                params.append(", ArrayUtils.EMPTY_STRING_ARRAY");
            }
            if (withNatural) {
                params.append(", ").append(naturalIdsParams.substring(2));
            }
            this.addLiteral(entityEnum, clazzName + '(' + params.toString() + ')');
            this.addImport((ObjectModelClassifier)entityEnum, clazz);
        }
        ObjectModelAttributeImpl attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "contract", "Class<? extends TopiaEntity>");
        attr.setDocumentation("The contract of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementationFQN", "String");
        attr.setDocumentation("The fully qualified name of the implementation of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "implementation", "Class<? extends TopiaEntity>");
        attr.setDocumentation("The implementation class of the entity (will be lazy computed at runtime).");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "naturalIds", "String[]");
        attr.setDocumentation("The array of property involved in the natural key of the entity.");
        attr = (ObjectModelAttributeImpl)this.addAttribute((ObjectModelClassifier)entityEnum, "notNulls", "String[]");
        attr.setDocumentation("The array of not null properties of the entity.");
        ObjectModelOperation op = this.addConstructor(entityEnum, (ObjectModelModifier)ObjectModelJavaModifier.PACKAGE);
        this.addParameter(op, "Class<? extends TopiaEntity >", "contract");
        this.addParameter(op, "String[]", "notNulls");
        this.addParameter(op, "String...", "naturalIds");
        this.setOperationBody(op, "\n            this.contract = contract;\n            this.notNulls = Arrays.copyOf(notNulls, notNulls.length);\n            this.naturalIds = naturalIds;\n            implementationFQN = contract.getName() + \"Impl\";\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getContract", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return contract;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getNaturalIds", "String[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return naturalIds;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "isUseNaturalIds", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return naturalIds.length > 0;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getNotNulls", "String[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return notNulls;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "isUseNotNulls", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return notNulls.length > 0;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementationFQN", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n            return implementationFQN;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "setImplementationFQN", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "String", "implementationFQN");
        if (generateOperator) {
            this.setOperationBody(op, "\n            this.implementationFQN = implementationFQN;\n            implementation = null;\n            // reinit the operators store\n            EntityOperatorStore.clear();\n    ");
        } else {
            this.setOperationBody(op, "\n            this.implementationFQN = implementationFQN;\n            this.implementation = null;\n    ");
        }
        op = this.addOperation((ObjectModelClassifier)entityEnum, "accept", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addParameter(op, "Class<? extends TopiaEntity>", "klass");
        this.setOperationBody(op, "\n            return " + daoHelperClazzName + ".getContractClass(klass) == contract;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "getImplementation", "Class<? extends TopiaEntity>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)entityEnum, (ObjectModelElement)op, Override.class);
        this.addImport((ObjectModelClassifier)entityEnum, TopiaException.class);
        this.setOperationBody(op, "\n            if (implementation == null) {\n            try {\n                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);\n                } catch (ClassNotFoundException e) {\n                    throw new TopiaException(\"could not find class \" + implementationFQN, e);\n                }\n            }\n            return implementation;\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "TopiaEntity", "entity");
        this.setOperationBody(op, "\n            return valueOf(entity.getClass());\n    ");
        op = this.addOperation((ObjectModelClassifier)entityEnum, "valueOf", entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<?>", "klass");
        this.setOperationBody(op, "\n            if (klass.isInterface()) {\n               return valueOf(klass.getSimpleName());\n            }\n            for (" + entityEnumName + " entityEnum : " + entityEnumName + ".values()) {\n" + "                if (entityEnum.getContract().isAssignableFrom(klass)) {\n" + "                    //todo check it works for inheritance\n" + "                    return entityEnum;\n" + "                }\n" + "            }\n" + "            throw new IllegalArgumentException(\"no entity defined for the class \" + klass + \" in : \" + Arrays.toString(" + entityEnumName + ".values()));\n" + "    ");
    }
}

