/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class TaasUserAbstract
extends TopiaEntityAbstract
implements TaasUser {
    protected String login;
    protected String password;
    protected String email;
    protected boolean enabled;
    protected Date lastConnectionDate;
    protected int numberOfConnection;
    protected String link;
    protected Collection<TaasPrincipal> principals;
    private static final long serialVersionUID = 3691037660360630576L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "email", String.class, (Object)this.email);
        visitor.visit((TopiaEntity)this, "enabled", Boolean.TYPE, (Object)this.enabled);
        visitor.visit((TopiaEntity)this, "lastConnectionDate", Date.class, (Object)this.lastConnectionDate);
        visitor.visit((TopiaEntity)this, "numberOfConnection", Integer.TYPE, (Object)this.numberOfConnection);
        visitor.visit((TopiaEntity)this, "link", String.class, (Object)this.link);
        visitor.visit((TopiaEntity)this, "principals", Collection.class, TaasPrincipal.class, this.principals);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        this.fireOnPreWrite("login", oldValue, login);
        this.login = login;
        this.fireOnPostWrite("login", oldValue, login);
    }

    @Override
    public String getLogin() {
        this.fireOnPreRead("login", this.login);
        String result = this.login;
        this.fireOnPostRead("login", this.login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        this.fireOnPreWrite("password", oldValue, password);
        this.password = password;
        this.fireOnPostWrite("password", oldValue, password);
    }

    @Override
    public String getPassword() {
        this.fireOnPreRead("password", this.password);
        String result = this.password;
        this.fireOnPostRead("password", this.password);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        this.fireOnPreWrite("email", oldValue, email);
        this.email = email;
        this.fireOnPostWrite("email", oldValue, email);
    }

    @Override
    public String getEmail() {
        this.fireOnPreRead("email", this.email);
        String result = this.email;
        this.fireOnPostRead("email", this.email);
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.fireOnPreWrite("enabled", oldValue, enabled);
        this.enabled = enabled;
        this.fireOnPostWrite("enabled", oldValue, enabled);
    }

    @Override
    public boolean isEnabled() {
        this.fireOnPreRead("enabled", this.enabled);
        boolean result = this.enabled;
        this.fireOnPostRead("enabled", this.enabled);
        return result;
    }

    @Override
    public boolean getEnabled() {
        this.fireOnPreRead("enabled", this.enabled);
        boolean result = this.enabled;
        this.fireOnPostRead("enabled", this.enabled);
        return result;
    }

    @Override
    public void setLastConnectionDate(Date lastConnectionDate) {
        Date oldValue = this.lastConnectionDate;
        this.fireOnPreWrite("lastConnectionDate", oldValue, lastConnectionDate);
        this.lastConnectionDate = lastConnectionDate;
        this.fireOnPostWrite("lastConnectionDate", oldValue, lastConnectionDate);
    }

    @Override
    public Date getLastConnectionDate() {
        this.fireOnPreRead("lastConnectionDate", this.lastConnectionDate);
        Date result = this.lastConnectionDate;
        this.fireOnPostRead("lastConnectionDate", this.lastConnectionDate);
        return result;
    }

    @Override
    public void setNumberOfConnection(int numberOfConnection) {
        int oldValue = this.numberOfConnection;
        this.fireOnPreWrite("numberOfConnection", oldValue, numberOfConnection);
        this.numberOfConnection = numberOfConnection;
        this.fireOnPostWrite("numberOfConnection", oldValue, numberOfConnection);
    }

    @Override
    public int getNumberOfConnection() {
        this.fireOnPreRead("numberOfConnection", this.numberOfConnection);
        int result = this.numberOfConnection;
        this.fireOnPostRead("numberOfConnection", this.numberOfConnection);
        return result;
    }

    @Override
    public void setLink(String link) {
        String oldValue = this.link;
        this.fireOnPreWrite("link", oldValue, link);
        this.link = link;
        this.fireOnPostWrite("link", oldValue, link);
    }

    @Override
    public String getLink() {
        this.fireOnPreRead("link", this.link);
        String result = this.link;
        this.fireOnPostRead("link", this.link);
        return result;
    }

    @Override
    public void addPrincipals(TaasPrincipal principals) {
        this.fireOnPreWrite("principals", null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }
        this.principals.add(principals);
        this.fireOnPostWrite("principals", this.principals.size(), null, principals);
    }

    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> principals) {
        if (principals == null) {
            return;
        }
        for (TaasPrincipal item : principals) {
            this.addPrincipals(item);
        }
    }

    @Override
    public void setPrincipals(Collection<TaasPrincipal> principals) {
        ArrayList<TaasPrincipal> oldValue = this.principals != null ? new ArrayList<TaasPrincipal>(this.principals) : null;
        this.fireOnPreWrite("principals", oldValue, principals);
        this.principals = principals;
        this.fireOnPostWrite("principals", oldValue, principals);
    }

    @Override
    public void removePrincipals(TaasPrincipal principals) {
        this.fireOnPreWrite("principals", principals, null);
        if (this.principals == null || !this.principals.remove(principals)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("principals", this.principals.size() + 1, principals, null);
    }

    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        ArrayList<TaasPrincipal> oldValue = new ArrayList<TaasPrincipal>(this.principals);
        this.fireOnPreWrite("principals", oldValue, this.principals);
        this.principals.clear();
        this.fireOnPostWrite("principals", oldValue, this.principals);
    }

    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return this.principals;
    }

    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return (TaasPrincipal)TopiaEntityHelper.getEntityByTopiaId(this.principals, (String)topiaId);
    }

    @Override
    public int sizePrincipals() {
        if (this.principals == null) {
            return 0;
        }
        return this.principals.size();
    }

    @Override
    public boolean isPrincipalsEmpty() {
        int size = this.sizePrincipals();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("login", (Object)this.login).append("password", (Object)this.password).append("email", (Object)this.email).append("enabled", this.enabled).append("lastConnectionDate", (Object)this.lastConnectionDate).append("numberOfConnection", this.numberOfConnection).append("link", (Object)this.link).append("principals", this.principals).toString();
        return result;
    }
}

