package org.nuiton.topia.security.entities.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TopiaUserAbstract extends TopiaEntityAbstract implements TopiaUser {

    public String login;
    public String email;
    public String password;
    public String note;
    public String linkApplication;
    public Collection<TopiaGroup> topiaGroup;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaUser.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaUser.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, LOGIN, String.class, login);
        visitor.visit(this, EMAIL, String.class, email);
        visitor.visit(this, PASSWORD, String.class, password);
        visitor.visit(this, NOTE, String.class, note);
        visitor.visit(this, LINK_APPLICATION, String.class, linkApplication);
        visitor.visit(this, TOPIA_GROUP, Collection.class, TopiaGroup.class, topiaGroup);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setLogin :
     * @param value 
     */

    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite(LOGIN, _oldValue, value);
        this.login = value;
        fireOnPostWrite(LOGIN, _oldValue, value);
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        fireOnPreRead(LOGIN, login);
        String result = this.login;
        fireOnPostRead(LOGIN, login);
        return result;
}

    /**
     * setEmail :
     * @param value 
     */

    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite(EMAIL, _oldValue, value);
        this.email = value;
        fireOnPostWrite(EMAIL, _oldValue, value);
}

    /**
     * getEmail :
     * @return String 
     */

    public String getEmail() {
        fireOnPreRead(EMAIL, email);
        String result = this.email;
        fireOnPostRead(EMAIL, email);
        return result;
}

    /**
     * setPassword :
     * @param value 
     */

    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite(PASSWORD, _oldValue, value);
        this.password = value;
        fireOnPostWrite(PASSWORD, _oldValue, value);
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        fireOnPreRead(PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PASSWORD, password);
        return result;
}

    /**
     * setNote :
     * @param value 
     */

    public void setNote(String value) {
        String _oldValue = this.note;
        fireOnPreWrite(NOTE, _oldValue, value);
        this.note = value;
        fireOnPostWrite(NOTE, _oldValue, value);
}

    /**
     * getNote :
     * @return String 
     */

    public String getNote() {
        fireOnPreRead(NOTE, note);
        String result = this.note;
        fireOnPostRead(NOTE, note);
        return result;
}

    /**
     * setLinkApplication :
     * @param value 
     */

    public void setLinkApplication(String value) {
        String _oldValue = this.linkApplication;
        fireOnPreWrite(LINK_APPLICATION, _oldValue, value);
        this.linkApplication = value;
        fireOnPostWrite(LINK_APPLICATION, _oldValue, value);
}

    /**
     * getLinkApplication :
     * @return String 
     */

    public String getLinkApplication() {
        fireOnPreRead(LINK_APPLICATION, linkApplication);
        String result = this.linkApplication;
        fireOnPostRead(LINK_APPLICATION, linkApplication);
        return result;
}

    /**
     * addTopiaGroup :
     * @param topiaGroup 
     */

    public void addTopiaGroup(TopiaGroup topiaGroup) {    
        fireOnPreWrite(TOPIA_GROUP, null, topiaGroup);
        if (this.topiaGroup == null) {
            this.topiaGroup = new ArrayList<TopiaGroup>();
        }
        if (topiaGroup.getTopiaUser() == null) {
            topiaGroup.setTopiaUser(new ArrayList<TopiaUser>());
        }
        topiaGroup.getTopiaUser().add(this);
        this.topiaGroup.add(topiaGroup);
        fireOnPostWrite(TOPIA_GROUP, this.topiaGroup.size(), null, topiaGroup);
}

    /**
     * addAllTopiaGroup :
     * @param values 
     */

    public void addAllTopiaGroup(Collection<TopiaGroup> values) {
        if (values == null) {
            return;
        }
        for (TopiaGroup item : values) {
            addTopiaGroup(item);
        }
}

    /**
     * getTopiaGroupByTopiaId :
     * @param topiaId 
     * @return TopiaGroup 
     */

    public TopiaGroup getTopiaGroupByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(topiaGroup, topiaId);
 }

    /**
     * setTopiaGroup :
     * @param values 
     */

    public void setTopiaGroup(Collection<TopiaGroup> values) {
        Collection<TopiaGroup> _oldValue = topiaGroup;
        fireOnPreWrite(TOPIA_GROUP, _oldValue, values);
        topiaGroup = values;
        fireOnPostWrite(TOPIA_GROUP, _oldValue, values);
}

    /**
     * removeTopiaGroup :
     * @param value 
     */

    public void removeTopiaGroup(TopiaGroup value) {
        fireOnPreWrite(TOPIA_GROUP, value, null);
        if ((this.topiaGroup == null) || (!this.topiaGroup.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.getTopiaUser().remove(this);
        fireOnPostWrite(TOPIA_GROUP, this.topiaGroup.size()+1, value, null);
}

    /**
     * clearTopiaGroup :
     */

    public void clearTopiaGroup() {
        if (this.topiaGroup == null) {
            return;
        }
        for (TopiaGroup item : this.topiaGroup) {
            item.getTopiaUser().remove(this);
        }
        Collection<TopiaGroup> _oldValue = new ArrayList<TopiaGroup>(this.topiaGroup);
        fireOnPreWrite(TOPIA_GROUP, _oldValue, this.topiaGroup);
        this.topiaGroup.clear();
        fireOnPostWrite(TOPIA_GROUP, _oldValue, this.topiaGroup);
}

    /**
     * getTopiaGroup :
     * @return Collection<TopiaGroup> 
     */

    public Collection<TopiaGroup> getTopiaGroup() {
        return topiaGroup;
}

    /**
     * sizeTopiaGroup :
     * @return int 
     */

    public int sizeTopiaGroup() {
        if (topiaGroup == null) {
            return 0;
        }
        return topiaGroup.size();
}

    /**
     * isTopiaGroupEmpty :
     * @return boolean 
     */

    public boolean isTopiaGroupEmpty() {
        int size = sizeTopiaGroup();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(LOGIN, this.login).
            append(EMAIL, this.email).
            append(PASSWORD, this.password).
            append(NOTE, this.note).
            append(LINK_APPLICATION, this.linkApplication).
         toString();
        return result;
}


} //TopiaUserAbstract
