package org.nuiton.topia.taas.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    protected String login;
    protected String password;
    protected String email;
    protected boolean enabled;
    protected Date lastConnectionDate;
    protected int numberOfConnection;
    public String link;
    public Collection<TaasPrincipal> principals;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "login", String.class, login);
        visitor.visit(this, "password", String.class, password);
        visitor.visit(this, "email", String.class, email);
        visitor.visit(this, "enabled", boolean.class, enabled);
        visitor.visit(this, "lastConnectionDate", Date.class, lastConnectionDate);
        visitor.visit(this, "numberOfConnection", int.class, numberOfConnection);
        visitor.visit(this, "link", String.class, link);
        visitor.visit(this, "principals", Collection.class, TaasPrincipal.class, principals);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setLogin :
     * @param value 
     */

    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        fireOnPostWrite("login", _oldValue, value);
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        fireOnPreRead("login", login);
        String result = this.login;
        fireOnPostRead("login", login);
        return result;
}

    /**
     * setPassword :
     * @param value 
     */

    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        fireOnPostWrite("password", _oldValue, value);
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        fireOnPreRead("password", password);
        String result = this.password;
        fireOnPostRead("password", password);
        return result;
}

    /**
     * setEmail :
     * @param value 
     */

    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        fireOnPostWrite("email", _oldValue, value);
}

    /**
     * getEmail :
     * @return String 
     */

    public String getEmail() {
        fireOnPreRead("email", email);
        String result = this.email;
        fireOnPostRead("email", email);
        return result;
}

    /**
     * setEnabled :
     * @param value 
     */

    public void setEnabled(boolean value) {
        boolean _oldValue = this.enabled;
        fireOnPreWrite("enabled", _oldValue, value);
        this.enabled = value;
        fireOnPostWrite("enabled", _oldValue, value);
}

    /**
     * getEnabled :
     * @return boolean 
     */

    public boolean getEnabled() {
        fireOnPreRead("enabled", enabled);
        boolean result = this.enabled;
        fireOnPostRead("enabled", enabled);
        return result;
}

    /**
     * setLastConnectionDate :
     * @param value 
     */

    public void setLastConnectionDate(Date value) {
        Date _oldValue = this.lastConnectionDate;
        fireOnPreWrite("lastConnectionDate", _oldValue, value);
        this.lastConnectionDate = value;
        fireOnPostWrite("lastConnectionDate", _oldValue, value);
}

    /**
     * getLastConnectionDate :
     * @return Date 
     */

    public Date getLastConnectionDate() {
        fireOnPreRead("lastConnectionDate", lastConnectionDate);
        Date result = this.lastConnectionDate;
        fireOnPostRead("lastConnectionDate", lastConnectionDate);
        return result;
}

    /**
     * setNumberOfConnection :
     * @param value 
     */

    public void setNumberOfConnection(int value) {
        int _oldValue = this.numberOfConnection;
        fireOnPreWrite("numberOfConnection", _oldValue, value);
        this.numberOfConnection = value;
        fireOnPostWrite("numberOfConnection", _oldValue, value);
}

    /**
     * getNumberOfConnection :
     * @return int 
     */

    public int getNumberOfConnection() {
        fireOnPreRead("numberOfConnection", numberOfConnection);
        int result = this.numberOfConnection;
        fireOnPostRead("numberOfConnection", numberOfConnection);
        return result;
}

    /**
     * setLink :
     * @param value 
     */

    public void setLink(String value) {
        String _oldValue = this.link;
        fireOnPreWrite("link", _oldValue, value);
        this.link = value;
        fireOnPostWrite("link", _oldValue, value);
}

    /**
     * getLink :
     * @return String 
     */

    public String getLink() {
        fireOnPreRead("link", link);
        String result = this.link;
        fireOnPostRead("link", link);
        return result;
}

    /**
     * addPrincipals :
     * @param principals 
     */

    public void addPrincipals(TaasPrincipal principals) {    
        fireOnPreWrite("principals", null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }
        this.principals.add(principals);
        fireOnPostWrite("principals", this.principals.size(), null, principals);
}

    /**
     * addAllPrincipals :
     * @param values 
     */

    public void addAllPrincipals(Collection<TaasPrincipal> values) {
        if (values == null) {
            return;
        }
        for (TaasPrincipal item : values) {
            addPrincipals(item);
        }
}

    /**
     * getPrincipalsByTopiaId :
     * @param topiaId 
     * @return TaasPrincipal 
     */

    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
 }

    /**
     * setPrincipals :
     * @param values 
     */

    public void setPrincipals(Collection<TaasPrincipal> values) {
        Collection<TaasPrincipal> _oldValue = principals;
        fireOnPreWrite("principals", _oldValue, values);
        principals = values;
        fireOnPostWrite("principals", _oldValue, values);
}

    /**
     * removePrincipals :
     * @param value 
     */

    public void removePrincipals(TaasPrincipal value) {
        fireOnPreWrite("principals", value, null);
        if ((this.principals == null) || (!this.principals.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("principals", this.principals.size()+1, value, null);
}

    /**
     * clearPrincipals :
     */

    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> _oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite("principals", _oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite("principals", _oldValue, this.principals);
}

    /**
     * getPrincipals :
     * @return Collection<TaasPrincipal> 
     */

    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
}

    /**
     * sizePrincipals :
     * @return int 
     */

    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
}

    /**
     * isPrincipalsEmpty :
     * @return boolean 
     */

    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("login", this.login).
            append("password", this.password).
            append("email", this.email).
            append("enabled", this.enabled).
            append("lastConnectionDate", this.lastConnectionDate).
            append("numberOfConnection", this.numberOfConnection).
            append("link", this.link).
            append("principals", this.principals).
         toString();
        return result;
}


} //TaasUserAbstract
