/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.operation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.replication.TopiaReplicationContext;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationLink;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class LoadLink
implements TopiaReplicationOperation {
    private static final Log log = LogFactory.getLog(LoadLink.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object ... parameters) {
    }

    @Override
    public void run(TopiaReplicationContext replicationContext, ReplicationOperationDef operationDef, TopiaContextImplementor srcCtxt, TopiaContextImplementor dstCtxt, List<? extends TopiaEntity> nodeEntities) throws TopiaException {
        ReplicationLink link = (ReplicationLink)operationDef.getParameters()[0];
        String name = link.getName();
        ReplicationNode ownerNode = link.getSource();
        if (!ownerNode.equals(operationDef.getNode())) {
            throw new IllegalStateException(I18n._((String)"topia.replication.error.operation.loadLink.illegalSource", (Object[])new Object[]{operationDef.getNode(), ownerNode}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentNode : " + operationDef.getNode() + " , link to load : " + link));
        }
        EntityOperator<? super TopiaEntity> ownerOperator = ownerNode.getOperator();
        for (TopiaEntity topiaEntity : nodeEntities) {
            int size = ownerOperator.sizeChild(name, topiaEntity);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("load association '" + name + "' on " + topiaEntity + " : " + size));
        }
    }
}

