/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.Link;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import org.nuiton.topia.replication.operation.AttachLink;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.LoadLink;

public class ReplicationModel {
    private static final Log log = LogFactory.getLog(ReplicationModel.class);
    protected final TopiaEntityEnum[] contracts;
    protected final String[] topiaIds;
    protected Map<Class<? extends TopiaEntity>, ReplicationNode> nodes;
    protected List<ReplicationNode> order;
    protected final boolean replicateAll;

    public ReplicationModel(TopiaEntityEnum[] contracts, Set<Class<? extends TopiaEntity>> types, String ... topiaIds) {
        this.contracts = contracts;
        this.topiaIds = topiaIds;
        this.replicateAll = false;
        this.nodes = new LinkedHashMap<Class<? extends TopiaEntity>, ReplicationNode>();
        this.order = new ArrayList<ReplicationNode>();
        HashMap<Class<? extends TopiaEntity>, ReplicationNode> tmpNodes = new HashMap<Class<? extends TopiaEntity>, ReplicationNode>();
        for (Class<? extends TopiaEntity> k : types) {
            TopiaEntityEnum e = TopiaEntityHelper.getEntityEnum(k, (TopiaEntityEnum[])contracts);
            ReplicationNode replicationNode = new ReplicationNode(e);
            tmpNodes.put(k, replicationNode);
        }
        this.nodes = Collections.unmodifiableMap(tmpNodes);
    }

    public ReplicationModel(TopiaEntityEnum[] contracts, boolean replicateAll, String ... topiaIds) {
        this.contracts = contracts;
        this.topiaIds = topiaIds;
        this.replicateAll = replicateAll;
        this.nodes = new LinkedHashMap<Class<? extends TopiaEntity>, ReplicationNode>();
        this.order = new ArrayList<ReplicationNode>();
        HashMap<Class, ReplicationNode> tmpNodes = new HashMap<Class, ReplicationNode>();
        for (TopiaEntityEnum e : contracts) {
            ReplicationNode replicationNode = new ReplicationNode(e);
            tmpNodes.put(e.getContract(), replicationNode);
            if (replicateAll) continue;
            this.order.add(replicationNode);
        }
        this.nodes = Collections.unmodifiableMap(tmpNodes);
    }

    public Collection<ReplicationNode> getNodes() {
        return this.nodes.values();
    }

    public Set<Class<? extends TopiaEntity>> getTypes() {
        return this.nodes.keySet();
    }

    public ReplicationNode getNode(Class<? extends TopiaEntity> clazz) {
        return this.nodes.get(clazz);
    }

    public ReplicationNode getNode(TopiaEntityEnum contract) {
        return this.nodes.get(contract.getContract());
    }

    public void addDependency(List<ReplicationNode> nodes) {
        this.order.addAll(nodes);
    }

    public TopiaEntityEnum[] getContracts() {
        return this.contracts;
    }

    public String[] getTopiaIds() {
        return this.topiaIds;
    }

    public List<ReplicationNode> getOrder() {
        return this.order;
    }

    public boolean isReplicateAll() {
        return this.replicateAll;
    }

    public ReplicationNode getNode(String propertyName, Class<?> propertyType) {
        Class<?> t;
        if (TopiaEntity.class.isAssignableFrom(propertyType) && this.nodes.containsKey(t = propertyType)) {
            ReplicationNode dep = this.getNode(t);
            return dep;
        }
        return null;
    }

    public void detectAssociations(TopiaEntityEnum ... filter) throws TopiaException {
        for (Class<? extends TopiaEntity> type : this.nodes.keySet()) {
            ReplicationNode node = this.getNode(type);
            EntityOperator<? super TopiaEntity> operator = node.getOperator();
            List associationProperties = operator.getAssociationProperties();
            if (associationProperties.isEmpty()) continue;
            for (String p : associationProperties) {
                ReplicationNode dep = this.getNode(p, operator.getAssociationPropertyType(p));
                if (dep == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("from type - " + type.getSimpleName() + " [" + p + ":" + dep + "]"));
                }
                node.addAssociation(p, dep);
            }
        }
    }

    public void detectDirectDependencies() throws TopiaException {
        for (Class<? extends TopiaEntity> type : this.nodes.keySet()) {
            ReplicationNode node = this.getNode(type);
            EntityOperator<? super TopiaEntity> operator = node.getOperator();
            List properties = operator.getProperties();
            if (properties.isEmpty()) continue;
            for (String p : properties) {
                ReplicationNode dep = this.getNode(p, operator.getPropertyType(p));
                if (dep == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("from type - " + type.getSimpleName() + " [" + p + ":" + dep + "]"));
                }
                node.addDependency(p, dep);
            }
        }
    }

    public void detectDependencies() throws TopiaException {
        HashSet<ReplicationNode> toResolved = new HashSet<ReplicationNode>(this.nodes.values());
        HashSet resolved = new HashSet();
        ArrayList levels = new ArrayList();
        while (!toResolved.isEmpty()) {
            HashSet<ReplicationNode> level = new HashSet<ReplicationNode>();
            for (ReplicationNode replicationNode : toResolved) {
                if (!replicationNode.hasDependency()) continue;
                for (ReplicationNode n : replicationNode.getDependencies().values()) {
                    if (resolved.contains(n)) continue;
                    level.add(n);
                }
            }
            HashSet<ReplicationNode> safeLevel = new HashSet<ReplicationNode>();
            if (level.isEmpty()) {
                safeLevel.addAll(toResolved);
            } else {
                for (ReplicationNode n : level) {
                    safeLevel.add(n);
                }
                if (safeLevel.isEmpty()) {
                    throw new IllegalStateException("un cycle dans les dependences a \u00e9t\u00e9 d\u00e9tect\u00e9, l'algorithme necessite plus de donnes... \n niveau courant : " + level + "\n resolus : " + this.getOrder());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] resolved : " + safeLevel));
            }
            toResolved.removeAll(safeLevel);
            resolved.addAll(safeLevel);
            levels.add(safeLevel);
            level.clear();
        }
        HashSet<ReplicationNode> done = new HashSet<ReplicationNode>();
        for (Set set : levels) {
            this.detectDependenciesOrder(set, done);
        }
    }

    public void detectDependenciesOrder(Set<ReplicationNode> safeLevel, Set<ReplicationNode> doned) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("will detect " + safeLevel));
        }
        HashMap<ReplicationNode, HashSet<ReplicationNode>> dico = new HashMap<ReplicationNode, HashSet<ReplicationNode>>();
        for (ReplicationNode n : safeLevel) {
            HashSet<ReplicationNode> hashSet = new HashSet<ReplicationNode>(n.getShell());
            hashSet.retainAll(safeLevel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("shell to use for " + n + " : " + hashSet));
            }
            dico.put(n, hashSet);
        }
        ArrayList levels = new ArrayList();
        while (!dico.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] on  " + safeLevel));
                for (Map.Entry entry : dico.entrySet()) {
                    log.debug((Object)("node " + entry.getKey() + " : " + entry.getValue()));
                }
            }
            HashSet free = new HashSet();
            for (Map.Entry e : dico.entrySet()) {
                if (!((Set)e.getValue()).isEmpty()) continue;
                free.add(e.getKey());
            }
            if (free.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("level [" + levels.size() + "] cycle detecte : " + dico.keySet()));
                }
                throw new IllegalStateException("un cycle n'a pas pu etre resoud entre l'ensemble " + dico.keySet());
            }
            log.info((Object)("there is some free node(s) to resolve : " + free));
            for (Map.Entry e : dico.entrySet()) {
                Set list = (Set)e.getValue();
                list.removeAll(free);
            }
            for (ReplicationNode n : free) {
                dico.remove(n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] resolved : " + free));
            }
            levels.add(free);
            doned.addAll(free);
            if (!dico.isEmpty()) continue;
            break;
        }
        for (Set set : levels) {
            this.addDependency(new ArrayList<ReplicationNode>(set));
        }
        dico.clear();
        levels.clear();
    }

    public void detectObjectsToDettach() {
        HashSet<ReplicationNode> universe = new HashSet<ReplicationNode>();
        for (ReplicationNode node : this.getOrder()) {
            ReplicationNode nodeDst;
            if (node.hasAssociation()) {
                for (Map.Entry<String, ReplicationNode> e : node.getAssociations().entrySet()) {
                    nodeDst = e.getValue();
                    if (universe.contains(nodeDst)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("association to dettach " + e.getKey() + " for " + node));
                    }
                    node.addAssociationToDettach(e.getKey());
                }
            }
            if (node.hasDependency()) {
                for (Map.Entry<String, ReplicationNode> e : node.getDependencies().entrySet()) {
                    nodeDst = e.getValue();
                    if (universe.contains(nodeDst)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dependency to dettach " + e.getKey() + " for " + node));
                    }
                    node.addDependencyToDettach(e.getKey());
                }
            }
            universe.add(node);
        }
    }

    public void detectOperations() {
        HashSet<ReplicationNode> universe = new HashSet<ReplicationNode>();
        HashSet<Link> links = new HashSet<Link>();
        HashSet<Link> linksToLoad = new HashSet<Link>();
        for (ReplicationNode node : this.order) {
            Link link;
            if (!node.hasAssociation()) continue;
            for (Map.Entry<String, ReplicationNode> entry : node.getAssociations().entrySet()) {
                String name = entry.getKey();
                ReplicationNode target = node.getAssociations().get(name);
                link = new Link(node, target, name, true);
                if (!this.nodes.containsValue(target)) continue;
                links.add(link);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("link to treate : " + link));
            }
            List associationProperties = node.getOperator().getAssociationProperties();
            for (String name : associationProperties) {
                Class associationPropertyType = node.getOperator().getAssociationPropertyType(name);
                if (TopiaEntity.class.isAssignableFrom(associationPropertyType) && this.nodes.containsKey(associationPropertyType)) continue;
                link = new Link(node, null, name, true);
                linksToLoad.add(link);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("link to load before replication : " + link));
            }
        }
        for (ReplicationNode node : this.order) {
            ReplicationOperationDef op;
            log.debug((Object)("------------------------------- for node " + node));
            if (node.hasAssociationsToDettach()) {
                Set<String> names = node.getAssociationsToDettach();
                for (String name : names) {
                    this.addOperation(node, node, ReplicationOperationPhase.before, DettachAssociation.class, name);
                }
            }
            HashSet<Link> tmpLinks = new HashSet<Link>();
            for (Link link : linksToLoad) {
                if (!node.equals(link.getSource())) continue;
                tmpLinks.add(link);
            }
            if (!tmpLinks.isEmpty()) {
                for (Link link : tmpLinks) {
                    op = new ReplicationOperationDef(ReplicationOperationPhase.before, LoadLink.class, node, link);
                    node.addOperation(op);
                }
                linksToLoad.removeAll(links);
                tmpLinks.clear();
            }
            this.addOperation(node, node, ReplicationOperationPhase.duplicate, Duplicate.class, new Object[0]);
            universe.add(node);
            for (Link link : links) {
                if (!link.canReattach(universe, node)) continue;
                tmpLinks.add(link);
            }
            if (tmpLinks.isEmpty()) continue;
            for (Link link : tmpLinks) {
                op = new ReplicationOperationDef(ReplicationOperationPhase.after, AttachLink.class, node, link);
                node.addOperation(op);
            }
            links.removeAll(tmpLinks);
        }
    }

    public void adjustOperations(Map<Class<? extends TopiaEntity>, List<String>> data) {
        for (TopiaEntityEnum e : this.getContracts()) {
            Class contract = e.getContract();
            List<String> ids = data.get(contract);
            ReplicationNode node = this.getNode(contract);
            if (node == null || ids != null && !ids.isEmpty()) continue;
            List<ReplicationOperationDef> operations = node.getOperations();
            log.info((Object)("skip operations on node " + node + " (no data associated)"));
            for (ReplicationOperationDef op : operations) {
                log.info((Object)("  skip " + op));
            }
            operations.clear();
        }
    }

    public void detectShell() {
        for (ReplicationNode n : this.nodes.values()) {
            HashSet<ReplicationNode> shell = new HashSet<ReplicationNode>();
            this.getShell(n, shell);
            shell.remove(n);
            n.setShell(shell);
        }
    }

    protected void getShell(ReplicationNode node, Set<ReplicationNode> explored) {
        if (!explored.contains(node)) {
            explored.add(node);
        }
        if (node.hasAssociation()) {
            for (ReplicationNode n : node.getAssociations().values()) {
                if (explored.contains(n)) continue;
                this.getShell(n, explored);
            }
        }
        if (node.hasDependency()) {
            for (ReplicationNode n : node.getDependencies().values()) {
                if (explored.contains(n)) continue;
                this.getShell(n, explored);
            }
        }
    }

    protected void addOperation(ReplicationNode ownerNode, ReplicationNode node, ReplicationOperationPhase phase, Class<? extends TopiaReplicationOperation> operationClass, Object ... params) {
        ReplicationOperationDef op = new ReplicationOperationDef(phase, operationClass, node, params);
        ownerNode.addOperation(op);
    }
}

