/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: TopiaMigrationCallbackByMethod.java 2949 2013-12-20 14:59:42Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-service-migration/src/main/java/org/nuiton/topia/migration/TopiaMigrationCallbackByMethod.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.migration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.util.Version;

import java.lang.reflect.Method;

/**
 * Migration callback base on methods.
 * <p/>
 * The callback defines for each version of {@link #getAvailableVersions()}
 * a method named {@code migrate_on_XXX} where {@code XXX} is the version with
 * all dots replaces by underscores.
 * <p/>
 * Replace deprecated implementation {@code TopiaMigrationCallBack}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: TopiaMigrationCallbackByMethod.java 2949 2013-12-20 14:59:42Z tchemit $
 * @since 2.5
 */
public abstract class TopiaMigrationCallbackByMethod<PersistenceContext extends TopiaPersistenceContext& TopiaHibernateSupport & TopiaSqlSupport> extends AbstractTopiaMigrationCallback<PersistenceContext> {

    /** Logger */
    private static final Log log = LogFactory.getLog(TopiaMigrationCallbackByMethod.class);

    @Override
    protected void migrateForVersion(Version version,
                                     PersistenceContext tx,
                                     boolean showSql,
                                     boolean showProgression) throws Exception {

        String methodName = "migrateTo_" + version.getValidName();

        Method m = getClass().getMethod(methodName,
                                        TopiaPersistenceContext.class,
                                        boolean.class,
                                        boolean.class
        );

        m.setAccessible(true);

        if (log.isDebugEnabled()) {
            log.debug("launch method " + m.getName());
        }

        m.invoke(this, tx, showSql, showProgression);

    }


}