/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.history;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHistoryDAOHelper;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.history.NoHistory;
import org.nuiton.topia.history.entities.History;
import org.nuiton.topia.history.entities.HistoryDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

public class TopiaHistoryListener
implements TopiaEntityListener {
    private static Log log = LogFactory.getLog(TopiaHistoryListener.class);
    protected boolean historyCreate;
    protected boolean historyDelete;
    protected boolean historyUpdate;
    protected boolean historyLoad;
    protected TopiaContext context;

    public TopiaHistoryListener(TopiaContext context, boolean historyCreate, boolean historyDelete, boolean historyUpdate, boolean historyLoad) {
        this.context = context;
        this.historyCreate = historyCreate;
        this.historyDelete = historyDelete;
        this.historyUpdate = historyUpdate;
        this.historyLoad = historyLoad;
    }

    public void create(TopiaEntityEvent e) {
        if (this.historyCreate) {
            TopiaEntity entity = e.getEntity();
            this.addToHistory(entity, 2);
        }
    }

    public void delete(TopiaEntityEvent e) {
        if (this.historyDelete) {
            TopiaEntity entity = e.getEntity();
            this.addToHistory(entity, 8);
        }
    }

    public void update(TopiaEntityEvent e) {
        if (this.historyUpdate) {
            TopiaEntity entity = e.getEntity();
            this.addToHistory(entity, 4);
        }
    }

    public void load(TopiaEntityEvent e) {
        if (this.historyLoad) {
            TopiaEntity entity = e.getEntity();
            this.addToHistory(entity, 1);
        }
    }

    protected void addToHistory(TopiaEntity entity, int action) {
        block3: {
            if (!(entity instanceof NoHistory)) {
                String user = TopiaSecurityUtil.getUserPrincipal();
                Date date = new Date();
                try {
                    TopiaContext tx = this.context.beginTransaction();
                    HistoryDAO dao = TopiaHistoryDAOHelper.getHistoryDAO(tx);
                    History history = (History)dao.create(new Object[0]);
                    history.setActionDate(date);
                    history.setUserId(user);
                    history.setAction(action);
                    history.setTypeAndTarget(entity.getTopiaId());
                    tx.commitTransaction();
                    tx.closeContext();
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Can't add create action in history", (Throwable)eee);
                }
            }
        }
    }
}

