/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaVetoException;
import org.nuiton.topia.persistence.event.EntityState;
import org.nuiton.topia.persistence.event.TopiaContextEvent;
import org.nuiton.topia.persistence.event.TopiaEntitiesEvent;
import org.nuiton.topia.persistence.event.TopiaEntitiesVetoable;
import org.nuiton.topia.persistence.event.TopiaEntityEvent;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.event.TopiaSchemaListener;
import org.nuiton.topia.persistence.event.TopiaTransactionEvent;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.event.TopiaTransactionVetoable;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.util.CategorisedListenerSet;
import org.nuiton.util.ListenerSet;

public class TopiaFiresSupport
implements TopiaListenableSupport {
    private static final Log log = LogFactory.getLog(TopiaFiresSupport.class);
    static final Object NO_CHANGE = new Object();
    protected Map<TopiaEntity, EntityState> transactionEntities = new IdentityMap();
    protected Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    protected ListenerSet<TopiaTransactionListener> transactionListeners = new ListenerSet();
    protected ListenerSet<TopiaTransactionVetoable> transactionVetoables = new ListenerSet();
    protected CategorisedListenerSet<TopiaEntityListener> entityListeners = new CategorisedListenerSet();
    protected CategorisedListenerSet<TopiaEntityVetoable> entityVetoables = new CategorisedListenerSet();
    protected ListenerSet<TopiaEntitiesVetoable> entitiesVetoables = new ListenerSet();
    protected ListenerSet<TopiaSchemaListener> topiaSchemaListeners = new ListenerSet();

    public void warnOnLoadEntity(TopiaEntity entity) {
        EntityState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"warnOnReadEntity");
        }
        if ((state = this.transactionEntities.get(entity)) == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        state.addLoad();
    }

    public void warnOnCreateEntity(TopiaEntity entity) {
        EntityState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"warnOnCreateEntity");
        }
        if ((state = this.transactionEntities.get(entity)) == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        state.addCreate();
    }

    public void warnOnReadEntity(TopiaEntity entity) {
        EntityState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"warnOnReadEntity");
        }
        if ((state = this.transactionEntities.get(entity)) == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        state.addRead();
    }

    public void warnOnUpdateEntity(TopiaEntity entity) {
        EntityState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"warnOnUpdateEntity");
        }
        if ((state = this.transactionEntities.get(entity)) == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        state.addUpdate();
    }

    public void warnOnDeleteEntity(TopiaEntity entity) {
        EntityState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)"warnOnDeleteEntity");
        }
        if ((state = this.transactionEntities.get(entity)) == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        state.addDelete();
    }

    public void fireOnBeginTransaction(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnBeginTransaction");
        }
        TopiaTransactionEvent e = new TopiaTransactionEvent(context);
        for (TopiaTransactionVetoable listener : this.transactionVetoables) {
            try {
                listener.beginTransaction(e);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void fireOnPostCommit(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostCommit");
        }
        TopiaTransactionEvent e = new TopiaTransactionEvent(context, this.transactionEntities);
        for (TopiaTransactionListener listener : this.transactionListeners) {
            try {
                listener.commit(e);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't fireOnPostCommit", (Throwable)eee);
            }
        }
        this.transactionEntities.clear();
    }

    public void fireOnPostRollback(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostRollback");
        }
        TopiaTransactionEvent e = new TopiaTransactionEvent(context, this.transactionEntities);
        for (TopiaTransactionListener listener : this.transactionListeners) {
            try {
                listener.rollback(e);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't fireOnPostRollback", (Throwable)eee);
            }
        }
        this.transactionEntities.clear();
    }

    public void fireOnPreCreate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreCreate");
        }
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityVetoables.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityVetoable)l.next()).create(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void fireOnPostCreate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostCreate");
        }
        this.warnOnCreateEntity(entity);
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityListeners.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityListener)l.next()).create(event);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Can't fireOnPostCreate for entity: " + entity), (Throwable)eee);
            }
        }
    }

    public void fireOnPreLoad(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreLoad");
        }
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityVetoables.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityVetoable)l.next()).load(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void fireOnPostLoad(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostLoad");
        }
        this.warnOnLoadEntity(entity);
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityListeners.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityListener)l.next()).load(event);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Can't fireOnPostLoad for entity: " + entity), (Throwable)eee);
            }
        }
    }

    public void fireOnPreUpdate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreUpdate");
        }
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityVetoables.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityVetoable)l.next()).update(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void fireOnPostUpdate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostUpdate");
        }
        this.warnOnUpdateEntity(entity);
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityListeners.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityListener)l.next()).update(event);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Can't fireOnPostUpdate for entity: " + entity), (Throwable)eee);
            }
        }
    }

    public void fireOnPreDelete(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreDelete");
        }
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityVetoables.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityVetoable)l.next()).delete(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void fireOnPostDelete(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostDelete");
        }
        this.warnOnDeleteEntity(entity);
        TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
        Iterator l = this.entityListeners.iterator(entity.getClass());
        while (l.hasNext()) {
            try {
                ((TopiaEntityListener)l.next()).delete(event);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("Can't fireOnPostDelete for entity: " + entity), (Throwable)eee);
            }
        }
    }

    public void fireOnPreRead(VetoableChangeSupport vetoables, TopiaEntity entity, String propertyName, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreRead");
        }
        try {
            vetoables.fireVetoableChange(propertyName, value, NO_CHANGE);
        }
        catch (Exception eee) {
            throw new TopiaVetoException(eee);
        }
    }

    public void fireOnPostRead(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, Object value) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostRead");
            }
            this.warnOnReadEntity(entity);
            try {
                listeners.firePropertyChange(propertyName, value, NO_CHANGE);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostRead", (Throwable)eee);
            }
        }
    }

    public void fireOnPostRead(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, int index, Object value) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostRead");
            }
            this.warnOnReadEntity(entity);
            try {
                listeners.fireIndexedPropertyChange(propertyName, index, value, NO_CHANGE);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostRead", (Throwable)eee);
            }
        }
    }

    public void fireOnPreWrite(VetoableChangeSupport vetoables, TopiaEntity entity, String propertyName, Object oldValue, Object newValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreWrite");
        }
        try {
            vetoables.fireVetoableChange(propertyName, oldValue, newValue);
        }
        catch (Exception eee) {
            throw new TopiaVetoException(eee);
        }
    }

    public void fireOnPostWrite(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, Object oldValue, Object newValue) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostWrite");
            }
            this.warnOnUpdateEntity(entity);
            if (this.propertyChangeListeners.size() > 0) {
                PropertyChangeEvent e = new PropertyChangeEvent(entity, propertyName, oldValue, newValue);
                for (PropertyChangeListener l : this.propertyChangeListeners) {
                    try {
                        l.propertyChange(e);
                    }
                    catch (Exception eee) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't fire property change for: " + propertyName), (Throwable)eee);
                    }
                }
            }
            try {
                listeners.firePropertyChange(propertyName, oldValue, newValue);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)("Can't fireOnPostWrite: " + propertyName), (Throwable)eee);
            }
        }
    }

    public void fireOnPostWrite(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, int index, Object oldValue, Object newValue) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostWrite");
            }
            this.warnOnUpdateEntity(entity);
            try {
                listeners.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostWrite", (Throwable)eee);
            }
        }
    }

    public void firePreCreateSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePreCreateSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.preCreateSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePostCreateSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.postCreateSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePreUpdateSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.preUpdateSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePostUpdateSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.postUpdateSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePreRestoreSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePreRestoreSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.preRestoreSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePostRestoreSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostRestoreSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.postRestoreSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePreDropSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePreDropSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.preDropSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public void firePostDropSchema(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostDropSchema");
        }
        TopiaContextEvent event = new TopiaContextEvent(context);
        for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
            try {
                topiaSchemaListener.postDropSchema(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
    }

    public <E extends TopiaEntity> List<E> fireEntitiesLoad(TopiaJpaSupport context, List<E> entities) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireEntitiesLoad");
        }
        List<E> result = entities;
        for (TopiaEntitiesVetoable entitiesVetoable : this.entitiesVetoables) {
            try {
                TopiaEntitiesEvent<E> event = new TopiaEntitiesEvent<E>(context, result);
                result = entitiesVetoable.load(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
        return result;
    }

    public CategorisedListenerSet<TopiaEntityListener> getEntityListeners() {
        return this.entityListeners;
    }

    public CategorisedListenerSet<TopiaEntityVetoable> getEntityVetoables() {
        return this.entityVetoables;
    }

    public ListenerSet<TopiaTransactionListener> getTransactionListeners() {
        return this.transactionListeners;
    }

    public ListenerSet<TopiaTransactionVetoable> getTransactionVetoable() {
        return this.transactionVetoables;
    }

    public ListenerSet<TopiaSchemaListener> getTopiaSchemaListeners() {
        return this.topiaSchemaListeners;
    }

    public ListenerSet<TopiaEntitiesVetoable> getTopiaEntitiesVetoable() {
        return this.entitiesVetoables;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.addTopiaEntityListener(TopiaEntity.class, listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entityListeners.add(entityClass, (Object)listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.addTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entityVetoables.add(entityClass, (Object)vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.transactionListeners.add((Object)listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.transactionVetoables.add((Object)vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void addTopiaSchemaListener(TopiaSchemaListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.topiaSchemaListeners.add((Object)listener);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entitiesVetoables.add((Object)vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.removeTopiaEntityListener(TopiaEntity.class, listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entityListeners.remove(entityClass, (Object)listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.removeTopiaEntityVetoable(TopiaEntity.class, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entityVetoables.remove(entityClass, (Object)vetoable);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.transactionListeners.remove((Object)listener);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.transactionVetoables.remove((Object)vetoable);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.propertyChangeListeners.remove(listener);
    }

    @Override
    public void removeTopiaSchemaListener(TopiaSchemaListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.topiaSchemaListeners.remove((Object)listener);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        if (vetoable == null) {
            throw new NullPointerException("listener can not be null.");
        }
        this.entitiesVetoables.remove((Object)vetoable);
    }
}

