/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHibernateSupport;
import org.nuiton.topia.TopiaSqlSupport;

public class HibernateTopiaSqlSupport
implements TopiaSqlSupport {
    protected TopiaHibernateSupport hibernateSupport;

    public HibernateTopiaSqlSupport(TopiaHibernateSupport hibernateSupport) {
        this.hibernateSupport = hibernateSupport;
    }

    @Override
    public void executeSQL(String sqlScript) {
        SQLWork sqlWork = new SQLWork(sqlScript);
        try {
            this.hibernateSupport.getHibernateSession().doWork((Work)sqlWork);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    public static class SQLWork
    implements Work {
        private final String script;

        public SQLWork(String script) {
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) throws SQLException {
            PreparedStatement sta = connection.prepareStatement(this.script);
            try {
                sta.execute();
            }
            finally {
                sta.close();
            }
        }
    }
}

