/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.nuiton.topia.HibernateProvider;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaApplicationContext;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;

public class TopiaDatabase
extends TestWatcher {
    private static final Log log = LogFactory.getLog(TopiaDatabase.class);
    public static final String TIMESTAMP = String.valueOf(System.nanoTime());
    private File testBasedir;
    private Properties dbConfiguration;
    private TopiaTestTopiaApplicationContext applicationContext;
    private Configuration hibernateCfg;
    private final String configurationPath;

    public TopiaDatabase() {
        this("/TopiaContextImpl.properties");
    }

    public TopiaDatabase(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void starting(Description description) {
        this.testBasedir = TopiaDatabase.getTestSpecificDirectory(description.getTestClass(), description.getMethodName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("testBasedir = " + this.testBasedir));
        }
        try {
            this.dbConfiguration = new Properties();
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(this.configurationPath);
            try {
                this.dbConfiguration.load(stream);
            }
            finally {
                stream.close();
            }
            this.dbConfiguration.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
            String dbPath = new File(this.testBasedir, "db").getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("dbPath = " + dbPath));
            }
            this.dbConfiguration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath);
            this.onDbConfigurationCreate(this.dbConfiguration, this.testBasedir, dbPath);
            this.applicationContext = new TopiaTestTopiaApplicationContext(this.dbConfiguration){

                protected HibernateProvider getHibernateProvider() {
                    HibernateProvider provider = super.getHibernateProvider();
                    TopiaDatabase.this.hibernateCfg = provider.getHibernateConfiguration();
                    return provider;
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start db at " + this.testBasedir, e);
        }
    }

    public void finished(Description description) {
        block3: {
            if (this.applicationContext != null && !this.applicationContext.isClosed()) {
                try {
                    this.applicationContext.closeContext();
                }
                catch (TopiaException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Could not close topia root context", (Throwable)e);
                }
            }
        }
        this.applicationContext = null;
        this.dbConfiguration = null;
    }

    public File getTestBasedir() {
        return this.testBasedir;
    }

    public Properties getDbConfiguration() {
        return this.dbConfiguration;
    }

    public TopiaTestTopiaApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Configuration getHibernateCfg() {
        return this.hibernateCfg;
    }

    public TopiaTestTopiaPersistenceContext beginTransaction() throws TopiaException {
        return this.applicationContext.newPersistenceContext();
    }

    protected void onDbConfigurationCreate(Properties configuration, File testDir, String dbPath) {
    }

    public static File getTestSpecificDirectory(Class<?> testClassName, String methodName) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            tempDirPath = "";
            if (log.isWarnEnabled()) {
                log.warn((Object)"'\"java.io.tmpdir\" not defined");
            }
        }
        File tempDirFile = new File(tempDirPath);
        String dataBasePath = testClassName.getName() + File.separator + methodName + '_' + TIMESTAMP;
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }
}

