package org.nuiton.topia.persistence.event;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaTransactionEvent.java 3002 2014-02-04 16:35:06Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-10/topia-persistence/src/main/java/org/nuiton/topia/persistence/event/TopiaTransactionEvent.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Event fires for {@link org.nuiton.topia.persistence.event.TopiaTransactionListener}.
 *
 * @author poussin <poussin@codelutin.com>
 * @see org.nuiton.topia.persistence.event.TopiaTransactionListener
 */
public class TopiaTransactionEvent extends EventObject {

    private static final long serialVersionUID = 1L;

    private Map<TopiaEntity, EntityState> entities = new IdentityHashMap<TopiaEntity, EntityState>();

    public TopiaTransactionEvent(TopiaPersistenceContext source) {
        super(source);
    }

    public TopiaTransactionEvent(TopiaPersistenceContext source,
                                 Map<TopiaEntity, EntityState> entities) {
        this(source);
        this.entities.putAll(entities);
    }

    public Set<TopiaEntity> getEntities() {
        return entities.keySet();
    }

    public boolean isLoad(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null && state.isLoad();
    }

    public boolean isRead(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null && state.isRead();
    }

    public boolean isCreate(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null && state.isCreate();
    }

    public boolean isUpdate(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null && state.isUpdate();
    }

    public boolean isDelete(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null && state.isDelete();
    }

    public boolean isModification(TopiaEntity entity) {
        EntityState state = entities.get(entity);
        return state != null
               && (state.isCreate() || state.isUpdate() || state.isDelete());
    }

    @Override
    public TopiaPersistenceContext getSource() {
        return (TopiaPersistenceContext) super.getSource();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (entities != null) {
            entities.clear();
            entities = null;
        }
    }
}
