/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.Product;

public abstract class DepartmentAbstract
extends TopiaEntityAbstract
implements Department {
    protected String name;
    protected Employe leader;
    protected Company company;
    protected Collection<Product> product;
    private static final long serialVersionUID = 4120851041491432033L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "leader", Employe.class, (Object)this.leader);
        visitor.visit((TopiaEntity)this, "company", Company.class, (Object)this.company);
        visitor.visit((TopiaEntity)this, "product", Collection.class, Product.class, this.product);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setLeader(Employe leader) {
        Employe oldValue = this.leader;
        this.fireOnPreWrite("leader", oldValue, leader);
        this.leader = leader;
        this.fireOnPostWrite("leader", oldValue, leader);
    }

    @Override
    public Employe getLeader() {
        this.fireOnPreRead("leader", this.leader);
        Employe result = this.leader;
        this.fireOnPostRead("leader", this.leader);
        return result;
    }

    @Override
    public void setCompany(Company company) {
        Company oldValue = this.company;
        this.fireOnPreWrite("company", oldValue, company);
        this.company = company;
        this.fireOnPostWrite("company", oldValue, company);
    }

    @Override
    public Company getCompany() {
        this.fireOnPreRead("company", this.company);
        Company result = this.company;
        this.fireOnPostRead("company", this.company);
        return result;
    }

    @Override
    public void addProduct(Product product) {
        this.fireOnPreWrite("product", null, product);
        if (this.product == null) {
            this.product = new ArrayList<Product>();
        }
        this.product.add(product);
        this.fireOnPostWrite("product", this.product.size(), null, product);
    }

    @Override
    public void addAllProduct(Collection<Product> product) {
        if (product == null) {
            return;
        }
        for (Product item : product) {
            this.addProduct(item);
        }
    }

    @Override
    public void setProduct(Collection<Product> product) {
        ArrayList<Product> oldValue = this.product != null ? new ArrayList<Product>(this.product) : null;
        this.fireOnPreWrite("product", oldValue, product);
        this.product = product;
        this.fireOnPostWrite("product", oldValue, product);
    }

    @Override
    public void removeProduct(Product product) {
        this.fireOnPreWrite("product", product, null);
        if (this.product == null || !this.product.remove(product)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("product", this.product.size() + 1, product, null);
    }

    @Override
    public void clearProduct() {
        if (this.product == null) {
            return;
        }
        ArrayList<Product> oldValue = new ArrayList<Product>(this.product);
        this.fireOnPreWrite("product", oldValue, this.product);
        this.product.clear();
        this.fireOnPostWrite("product", oldValue, this.product);
    }

    @Override
    public Collection<Product> getProduct() {
        return this.product;
    }

    @Override
    public Product getProductByTopiaId(String topiaId) {
        return (Product)TopiaEntityHelper.getEntityByTopiaId(this.product, (String)topiaId);
    }

    @Override
    public int sizeProduct() {
        if (this.product == null) {
            return 0;
        }
        return this.product.size();
    }

    @Override
    public boolean isProductEmpty() {
        int size = this.sizeProduct();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("leader", (Object)this.leader).append("product", this.product).toString();
        return result;
    }

    static {
        I18n.n((String)"topia.test.common.department", (Object[])new Object[0]);
        I18n.n((String)"topia.test.common.name", (Object[])new Object[0]);
        I18n.n((String)"topia.test.common.leader", (Object[])new Object[0]);
        I18n.n((String)"topia.test.common.company", (Object[])new Object[0]);
        I18n.n((String)"topia.test.common.product", (Object[])new Object[0]);
    }
}

