package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class Telephone2Abstract extends Contact2Impl implements Telephone2 {

    protected String prefix;
    protected String country;
static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.telephone2");
    org.nuiton.i18n.I18n.n_("topia.test.common.prefix");
    org.nuiton.i18n.I18n.n_("topia.test.common.country");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_PREFIX, String.class, prefix);
        visitor.visit(this, PROPERTY_COUNTRY, String.class, country);
        visitor.end(this);
}

    /**
     * setPrefix :
     * @param prefix 
     */

    @Override
    public void setPrefix(String prefix) {
        String oldValue = this.prefix;
        fireOnPreWrite(PROPERTY_PREFIX, oldValue, prefix);
        this.prefix = prefix;
        fireOnPostWrite(PROPERTY_PREFIX, oldValue, prefix);
}

    /**
     * getPrefix :
     * @return String 
     */

    @Override
    public String getPrefix() {
        fireOnPreRead(PROPERTY_PREFIX, prefix);
        String result = this.prefix;
        fireOnPostRead(PROPERTY_PREFIX, prefix);
        return result;
}

    /**
     * setCountry :
     * @param country 
     */

    @Override
    public void setCountry(String country) {
        String oldValue = this.country;
        fireOnPreWrite(PROPERTY_COUNTRY, oldValue, country);
        this.country = country;
        fireOnPostWrite(PROPERTY_COUNTRY, oldValue, country);
}

    /**
     * getCountry :
     * @return String 
     */

    @Override
    public String getCountry() {
        fireOnPreRead(PROPERTY_COUNTRY, country);
        String result = this.country;
        fireOnPostRead(PROPERTY_COUNTRY, country);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_PREFIX, this.prefix).
            append(PROPERTY_COUNTRY, this.country).
         toString();
        return result;
}


} //Telephone2Abstract
