/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class TopiaQuery<E extends TopiaEntity> {
    private static final Log log = LogFactory.getLog(TopiaQuery.class);
    protected List<Object> params;
    protected String select;
    protected boolean distinct;
    protected String from;
    protected String where;
    protected String orderBy;
    protected String groupBy;
    protected Integer startIndex;
    protected Integer endIndex;
    protected boolean parentheses = true;
    protected List<String> propertiesToLoad;
    protected Class<E> mainEntityClass;
    protected String mainAlias;
    protected TopiaDAO<E> dao;

    protected TopiaQuery(Class<E> entityClass) {
        this.mainEntityClass = entityClass;
        this.from = " FROM " + this.mainEntityClass.getName();
    }

    protected TopiaQuery(TopiaDAO<E> dao) {
        this(dao.getEntityClass());
        this.dao = dao;
    }

    protected TopiaQuery(Class<E> entityClass, String alias) {
        this(entityClass);
        this.mainAlias = alias;
        this.from = this.from + " " + alias;
    }

    protected TopiaQuery(TopiaDAO<E> dao, String alias) {
        this(dao.getEntityClass(), alias);
        this.dao = dao;
    }

    public static <T extends TopiaEntity> TopiaQuery<T> createQuery(Class<T> entityClass) {
        return new TopiaQuery<T>(entityClass);
    }

    public static <T extends TopiaEntity> TopiaQuery<T> createQuery(TopiaDAO<T> dao) {
        return new TopiaQuery<T>(dao);
    }

    public static <T extends TopiaEntity> TopiaQuery<T> createQuery(Class<T> entityClass, String alias) {
        return new TopiaQuery<T>(entityClass, alias);
    }

    public static <T extends TopiaEntity> TopiaQuery<T> createQuery(TopiaDAO<T> dao, String alias) {
        return new TopiaQuery<T>(dao, alias);
    }

    public String toString() {
        return this.fullQuery() + "; (PARAMS : " + this.getParams() + "); (LIMIT : " + this.startIndex + ", " + this.endIndex + ")";
    }

    public String fullQuery() {
        String result = "";
        String selectKeyWord = "SELECT ";
        selectKeyWord = selectKeyWord + (this.distinct ? " DISTINCT " : "");
        if (this.select != null) {
            result = selectKeyWord + this.select;
        } else if (this.from.contains(",") && !StringUtils.isEmpty((String)this.mainAlias)) {
            result = selectKeyWord + this.mainAlias;
        }
        result = result + this.from;
        if (this.where != null) {
            result = result + this.where;
        }
        if (this.groupBy != null) {
            result = result + this.groupBy;
        }
        if (this.orderBy != null) {
            result = result + this.orderBy;
        }
        return result.trim();
    }

    public TopiaQuery<E> addParam(String id, Object paramValue) {
        this.getParams().add(id);
        this.getParams().add(paramValue);
        return this;
    }

    public TopiaQuery<E> addParams(List<Object> params) {
        for (int i = 0; i < params.size(); i += 2) {
            String paramName = (String)params.get(i);
            this.addParam(this.getValueName(paramName), params.get(i + 1));
        }
        return this;
    }

    public List<Object> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<Object>();
        }
        return this.params;
    }

    public String getMainAlias() {
        return this.mainAlias;
    }

    public TopiaQuery<E> addLoad(String ... properties) {
        this.getPropertiesToLoad().addAll(Arrays.asList(properties));
        return this;
    }

    protected List<String> getPropertiesToLoad() {
        if (this.propertiesToLoad == null) {
            this.propertiesToLoad = new ArrayList<String>();
        }
        return this.propertiesToLoad;
    }

    public TopiaQuery<E> add(String where) {
        if (StringUtils.isEmpty((String)where)) {
            return this;
        }
        this.where = this.where == null ? " WHERE " : this.where + " AND ";
        if (this.parentheses) {
            this.where = this.where + "(";
        }
        this.where = this.where + where;
        if (this.parentheses) {
            this.where = this.where + ")";
        }
        this.parentheses = true;
        return this;
    }

    public TopiaQuery<E> add(String paramName, Op constraint, Object paramValue) {
        if (paramValue == null) {
            return this.add(paramName + " " + (Object)((Object)Op.NULL));
        }
        String valueName = this.getValueName(paramName);
        this.parentheses = false;
        return this.add(paramName + " " + (Object)((Object)constraint) + " :" + valueName).addParam(valueName, paramValue);
    }

    protected String getValueName(String paramName) {
        int dot = paramName.lastIndexOf(".");
        String valueName = paramName;
        if (dot != -1) {
            valueName = paramName.substring(dot + 1);
        }
        if (this.getParams().contains(valueName)) {
            valueName = valueName + "_" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        return valueName;
    }

    public TopiaQuery<E> addNotNull(String paramName) {
        return this.add(paramName + " " + (Object)((Object)Op.NOT_NULL));
    }

    public TopiaQuery<E> add(String paramName, Object paramValue) {
        return this.add(paramName, Op.EQ, paramValue);
    }

    public TopiaQuery<E> add(String paramName, Collection<Object> values) {
        return this.add(paramName, values, false);
    }

    public TopiaQuery<E> add(String paramName, Collection<Object> values, boolean isNull) {
        String queryIn = "";
        if (!values.isEmpty()) {
            queryIn = queryIn + paramName + " IN (";
            int count = 1;
            for (Object value : values) {
                String valueName = this.getValueName(paramName + count);
                if (count != 1) {
                    queryIn = queryIn + ", ";
                }
                queryIn = queryIn + ":" + valueName;
                this.addParam(valueName, value);
                ++count;
            }
            queryIn = queryIn + ")";
        }
        if (isNull) {
            queryIn = queryIn + (!values.isEmpty() ? " OR " : "");
            queryIn = queryIn + paramName + " IS NULL";
        }
        return this.add(queryIn);
    }

    public TopiaQuery<E> add(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            this.add(key, properties.get(key));
        }
        return this;
    }

    public TopiaQuery<E> addFrom(String str) {
        this.from = this.from + ", " + str;
        return this;
    }

    public TopiaQuery<E> addSelect(String select) {
        if (this.mainAlias != null && select.equals(this.mainAlias)) {
            return this;
        }
        this.select = this.select != null ? this.select + ", " : (this.mainAlias != null ? this.mainAlias + ", " : "");
        this.select = this.select + select;
        return this;
    }

    public TopiaQuery<E> setSelect(String select) {
        this.select = select;
        return this;
    }

    public TopiaQuery<E> addDistinct() {
        this.distinct = true;
        return this;
    }

    public TopiaQuery<E> addOrder(String order) {
        this.orderBy = this.orderBy == null ? " ORDER BY " : this.orderBy + ", ";
        this.orderBy = this.orderBy + order;
        return this;
    }

    public TopiaQuery<E> addOrderDesc(String order) {
        return this.addOrder(order + " DESC");
    }

    public TopiaQuery<E> addGroup(String group) {
        this.groupBy = this.groupBy == null ? " GROUP BY " : this.groupBy + ", ";
        this.groupBy = this.groupBy + group;
        return this;
    }

    public TopiaQuery<E> setLimit(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
        return this;
    }

    public TopiaQuery<E> resetLimit() {
        this.startIndex = null;
        this.endIndex = null;
        return this;
    }

    public TopiaQuery<E> setMaxResults(int max) {
        return this.setLimit(0, max - 1);
    }

    public List execute(TopiaContext transaction) throws TopiaException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("# QUERY : " + this.fullQuery()));
            log.trace((Object)("# PARAMS : " + Arrays.toString(this.params.toArray())));
        }
        if (this.startIndex != null && this.endIndex != null) {
            return transaction.find(this.fullQuery(), this.startIndex, this.endIndex, this.getParams().toArray());
        }
        return transaction.find(this.fullQuery(), this.getParams().toArray());
    }

    public List execute() throws TopiaException {
        this.validateDAO();
        return this.execute(this.dao.getContext());
    }

    public List<E> executeToEntityList(TopiaContext transaction) throws TopiaException, ClassCastException {
        List res = this.execute(transaction);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Properties to load : " + this.getPropertiesToLoad()));
        }
        ArrayList<TopiaEntity> results = new ArrayList<TopiaEntity>();
        for (Object o : res) {
            if (o == null) continue;
            if (o instanceof Object[]) {
                o = ((Object[])o)[0];
            }
            if (!this.mainEntityClass.isAssignableFrom(o.getClass())) {
                throw new ClassCastException(o.getClass().getName() + " can't be cast to " + this.mainEntityClass.getName() + " o : " + o);
            }
            TopiaEntity entity = (TopiaEntity)o;
            if (this.distinct && results.contains(entity)) continue;
            if (!this.getPropertiesToLoad().isEmpty()) {
                this.loadProperties(entity);
            }
            results.add(entity);
        }
        return results;
    }

    public List<E> executeToEntityList() throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.executeToEntityList(this.dao.getContext());
    }

    public <K> Map<K, E> executeToEntityMap(TopiaContext transaction, String keyName, Class<K> keyClass) throws TopiaException, ClassCastException {
        LinkedHashMap<Object, TopiaEntity> results = new LinkedHashMap<Object, TopiaEntity>();
        for (TopiaEntity elmt : this.executeToEntityList(transaction)) {
            Object value = this.loadProperty(elmt, keyName);
            if (value != null && !keyClass.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(value.getClass().getName() + " can't be cast to " + keyClass.getName());
            }
            results.put(value, elmt);
        }
        return results;
    }

    public <K> Map<K, E> executeToEntityMap(String keyName, Class<K> keyClass) throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.executeToEntityMap(this.dao.getContext(), keyName, keyClass);
    }

    public Map<String, E> executeToEntityMap(TopiaContext transaction) throws TopiaException, ClassCastException {
        return this.executeToEntityMap(transaction, "topiaId", String.class);
    }

    public Map<String, E> executeToEntityMap() throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.executeToEntityMap(this.dao.getContext());
    }

    public E executeToEntity(TopiaContext transaction) throws TopiaException, ClassCastException {
        this.setMaxResults(1);
        List<E> results = this.executeToEntityList(transaction);
        this.resetLimit();
        return (E)(!results.isEmpty() ? (TopiaEntity)results.get(0) : null);
    }

    public E executeToEntity() throws TopiaException, ClassCastException {
        this.validateDAO();
        return this.executeToEntity(this.dao.getContext());
    }

    public int executeToInteger(TopiaContext transaction, String select) throws TopiaException {
        Long res = (Long)this.executeToObject(transaction, select);
        return res != null ? res.intValue() : 0;
    }

    public int executeToInteger(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToInteger(this.dao.getContext(), select);
    }

    public String executeToString(TopiaContext transaction, String select) throws TopiaException {
        Object res = this.executeToObject(transaction, select);
        return res != null ? (String)res : "";
    }

    public String executeToString(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToString(this.dao.getContext(), select);
    }

    public Object executeToObject(TopiaContext transaction, String select) throws TopiaException {
        String oldValue = this.select;
        if (!StringUtils.isEmpty((String)select)) {
            this.setSelect(select);
        }
        Object result = null;
        this.setMaxResults(1);
        List results = this.execute(transaction);
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        this.select = oldValue;
        this.resetLimit();
        return result;
    }

    public Object executeToObject(String select) throws TopiaException {
        this.validateDAO();
        return this.executeToObject(this.dao.getContext(), select);
    }

    public int executeCount(TopiaContext transaction) throws TopiaException {
        return this.executeToInteger(transaction, "COUNT(*)");
    }

    public int executeCount() throws TopiaException {
        this.validateDAO();
        return this.executeCount(this.dao.getContext());
    }

    protected boolean validateDAO() throws TopiaException {
        if (this.dao == null) {
            throw new TopiaException("DAO not defined in TopiaQuery, can't execute it without TopiaContext");
        }
        return true;
    }

    protected <T extends TopiaEntity> void loadProperties(T entity) throws TopiaException {
        for (String prop : this.getPropertiesToLoad()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("load property " + prop + " ..."));
            }
            List<String> str = Arrays.asList(prop.split("\\."));
            Iterator<String> it = str.iterator();
            Object currEntity = entity;
            while (it.hasNext()) {
                String s = it.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Current entity : " + currEntity.getClass().getSimpleName()));
                    log.trace((Object)("Current loading : " + s));
                }
                if (it.hasNext()) {
                    currEntity = this.loadEntityProperty(currEntity, s);
                    continue;
                }
                this.loadProperty(currEntity, s);
            }
        }
    }

    protected <T extends TopiaEntity> TopiaEntity loadEntityProperty(T entity, String property) throws TopiaException {
        return (TopiaEntity)this.loadProperty(entity, property);
    }

    protected <T extends TopiaEntity> Object loadProperty(T entity, String property) throws TopiaException {
        try {
            Object res = PropertyUtils.getProperty(entity, (String)property);
            if (log.isTraceEnabled()) {
                log.trace((Object)("load property '" + property + "' for '" + entity.getClass().getSimpleName() + "'"));
            }
            if (res != null && Collection.class.isAssignableFrom(res.getClass())) {
                Collection list = (Collection)res;
                list.size();
            }
            return res;
        }
        catch (IllegalAccessException eee) {
            throw new TopiaException("Illegal access on property " + property + " from entity " + entity.getClass().getName(), eee);
        }
        catch (InvocationTargetException eee) {
            throw new TopiaException("Invocation error on entity " + entity.getClass().getName() + " for property " + property, eee);
        }
        catch (NoSuchMethodException eee) {
            throw new TopiaException("Getter method does not exist for property " + property + " from entity " + entity.getClass().getName(), eee);
        }
    }

    public static enum Op {
        EQ("="),
        GT(">"),
        GE(">="),
        LIKE("LIKE"),
        LT("<"),
        LE("<="),
        NOT_NULL("IS NOT NULL"),
        NULL("IS NULL");

        protected String value;

        private Op(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

