package org.nuiton.topia.test.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PersonAbstract extends TopiaEntityAbstract implements Person {

    public String name;
    public String firstname;
    public Collection<Pet> pet;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Person.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Person.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "firstname", String.class, firstname);
        visitor.visit(this, "pet", Collection.class, Pet.class, pet);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setFirstname :
     * @param value 
     */

    public void setFirstname(String value) {
        String _oldValue = this.firstname;
        fireOnPreWrite("firstname", _oldValue, value);
        this.firstname = value;
        fireOnPostWrite("firstname", _oldValue, value);
}

    /**
     * getFirstname :
     * @return String 
     */

    public String getFirstname() {
        fireOnPreRead("firstname", firstname);
        String result = this.firstname;
        fireOnPostRead("firstname", firstname);
        return result;
}

    /**
     * addPet :
     * @param pet 
     */

    public void addPet(Pet pet) {    
        fireOnPreWrite("pet", null, pet);
        if (this.pet == null) {
            this.pet = new ArrayList<Pet>();
        }
        pet.setPerson(this);
        this.pet.add(pet);
        fireOnPostWrite("pet", this.pet.size(), null, pet);
}

    /**
     * addAllPet :
     * @param values 
     */

    public void addAllPet(Collection<Pet> values) {
        if (values == null) {
            return;
        }
        for (Pet item : values) {
            addPet(item);
        }
}

    /**
     * getPetByTopiaId :
     * @param topiaId 
     * @return Pet 
     */

    public Pet getPetByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(pet, topiaId);
 }

    /**
     * setPet :
     * @param values 
     */

    public void setPet(Collection<Pet> values) {
        Collection<Pet> _oldValue = pet;
        fireOnPreWrite("pet", _oldValue, values);
        pet = values;
        fireOnPostWrite("pet", _oldValue, values);
}

    /**
     * removePet :
     * @param value 
     */

    public void removePet(Pet value) {
        fireOnPreWrite("pet", value, null);
        if ((this.pet == null) || (!this.pet.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPerson(null);
        fireOnPostWrite("pet", this.pet.size()+1, value, null);
}

    /**
     * clearPet :
     */

    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        Collection<Pet> _oldValue = new ArrayList<Pet>(this.pet);
        fireOnPreWrite("pet", _oldValue, this.pet);
        this.pet.clear();
        fireOnPostWrite("pet", _oldValue, this.pet);
}

    /**
     * getPet :
     * @return Collection<Pet> 
     */

    public Collection<Pet> getPet() {
        return pet;
}

    /**
     * sizePet :
     * @return int 
     */

    public int sizePet() {
        if (pet == null) {
            return 0;
        }
        return pet.size();
}

    /**
     * isPetEmpty :
     * @return boolean 
     */

    public boolean isPetEmpty() {
        int size = sizePet();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("firstname", this.firstname).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.person");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.firstname");
    org.nuiton.i18n.I18n.n_("topia.test.common.pet");
    }

} //PersonAbstract
