package org.nuiton.topia.it;

/*
 * #%L
 * ToPIA :: IT
 * $Id: TopiaConfigurationHelper.java 3031 2014-03-14 16:31:08Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-7/topia-it/src/main/java/org/nuiton/topia/it/TopiaConfigurationHelper.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Environment;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaConfigurationConstants;
import org.nuiton.topia.junit.ConfigurationHelper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Created on 11/22/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 */
public class TopiaConfigurationHelper extends ConfigurationHelper {

    /** Logger. */
    private static final Log log = LogFactory.getLog(TopiaConfigurationHelper.class);

    public static final String DEFAULT_CONFIGURATION_LOCATION = "/TopiaContextImpl.properties";

//    public static AbstractTopiaApplicationContext initTopiaContext(File testDirectory,
//                                                String dbname)
//            throws IOException, TopiaNotFoundException {
//
//
//        AbstractTopiaApplicationContext topiaContext = initTopiaContext(
//                testDirectory,
//                DEFAULT_CONFIGURATION_LOCATION,
//                dbname
//        );
//        return topiaContext;
//    }
//
//    public static AbstractTopiaApplicationContext initTopiaContext(File testDirectory,
//                                                String dbPropertiesPath,
//                                                String dbname)
//            throws IOException, TopiaNotFoundException {
//
//        Properties configuration = initTopiaContextConfiguration(
//                testDirectory,
//                dbPropertiesPath,
//                dbname);
//        return TopiaContextFactory.getContext(configuration);
//    }

    public static Properties initTopiaContextConfiguration(File testDirectory,
                                                           String dbPropertiesPath,
                                                           String dbname)
            throws IOException {

        Properties configuration = loadHibernateConfiguration(dbPropertiesPath);

        // make sure we always use a different directory

        String dbPath = getDbName(testDirectory, dbname);

        if (log.isInfoEnabled()) {
            log.info("dbPath = " + dbPath);
        }
        configuration.setProperty(
                Environment.URL,
//                "hibernate.connection.url",
                "jdbc:h2:file:" + dbPath);

        return configuration;
    }

    public static Properties loadHibernateConfiguration(String dbPropertiesPath) throws IOException {
        InputStream stream = TopiaConfigurationHelper.class.getResourceAsStream(dbPropertiesPath);

        Properties configuration = new Properties();

        configuration.load(stream);
        configuration.setProperty(
                TopiaConfigurationConstants.CONFIG_PERSISTENCE_CLASSES,
                TopiaItLegacyEntityEnum.getImplementationClassesAsString());
        return configuration;
    }

    public static String getDbName(File testDirectory, String dbname) {
        return new File(testDirectory,
                        dbname + '_' + System.nanoTime()).getAbsolutePath();
    }

    public static Properties initTopiaContextConfiguration(File testDirectory,
                                                           String dbname)
            throws IOException {

        return initTopiaContextConfiguration(
                testDirectory,
                DEFAULT_CONFIGURATION_LOCATION,
                dbname
        );
    }
}
