package org.nuiton.topia.it.mapping.test1;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed May 21 16:38:14 CEST 2014")
public abstract class A11Abstract extends AbstractTopiaEntity implements A11 {

    /**
     * Nom de l'attribut en BD : roleB11
     */
    protected Collection<B11> roleB11;

    private static final long serialVersionUID = 3486455938399942448L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ROLE_B11, Collection.class, B11.class, roleB11);
        visitor.end(this);
    }

    @Override
    public void addRoleB11(B11 roleB11) {
        fireOnPreWrite(PROPERTY_ROLE_B11, null, roleB11);
        if (this.roleB11 == null) {
            this.roleB11 = new LinkedList<B11>();
        }

        this.roleB11.add(roleB11);
        fireOnPostWrite(PROPERTY_ROLE_B11, this.roleB11.size(), null, roleB11);
    }

    @Override
    public void addAllRoleB11(Collection<B11> roleB11) {
        if (roleB11 == null) {
            return;
        }
        for (B11 item : roleB11) {
            addRoleB11(item);
        }
    }

    @Override
    public void setRoleB11(Collection<B11> roleB11) {
        // Copy elements to keep data for fire with new reference
        Collection<B11> oldValue = this.roleB11 != null ? new LinkedList<B11>(this.roleB11) : null;
        fireOnPreWrite(PROPERTY_ROLE_B11, oldValue, roleB11);
        this.roleB11 = roleB11;
        fireOnPostWrite(PROPERTY_ROLE_B11, oldValue, roleB11);
    }

    @Override
    public void removeRoleB11(B11 roleB11) {
        fireOnPreWrite(PROPERTY_ROLE_B11, roleB11, null);
        if (this.roleB11 == null || !this.roleB11.remove(roleB11)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ROLE_B11, this.roleB11.size() + 1, roleB11, null);
    }

    @Override
    public void clearRoleB11() {
        if (this.roleB11 == null) {
            return;
        }
        Collection<B11> oldValue = new LinkedList<B11>(this.roleB11);
        fireOnPreWrite(PROPERTY_ROLE_B11, oldValue, this.roleB11);
        this.roleB11.clear();
        fireOnPostWrite(PROPERTY_ROLE_B11, oldValue, this.roleB11);
    }

    @Override
    public Collection<B11> getRoleB11() {
        return roleB11;
    }

    @Override
    public B11 getRoleB11ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB11, topiaId);
    }

    @Override
    public Collection<String> getRoleB11TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test1.B11> tmp = getRoleB11();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB11() {
        if (roleB11 == null) {
            return 0;
        }
        return roleB11.size();
    }

    @Override
    public boolean isRoleB11Empty() {
        int size = sizeRoleB11();
        return size == 0;
    }

    @Override
    public boolean isRoleB11NotEmpty() {
        boolean empty = isRoleB11Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB11(B11 roleB11) {
        boolean contains = this.roleB11 !=null && this.roleB11.contains(roleB11);
        return contains;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ROLE_B11, this.roleB11).
         toString();
        return result;
    }

} //A11Abstract
