package org.nuiton.topia.it.legacy.topiatest;

/*
 * #%L
 * ToPIA :: IT
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed May 21 16:38:14 CEST 2014")
public abstract class ProductAbstract extends AbstractTopiaItLegacyEntity implements Product {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : type
     */
    protected Type type;

    private static final long serialVersionUID = 3546919190825886769L;

    static {
    
        I18n.n("topia.test.common.product");
        I18n.n("topia.test.common.name");
        I18n.n("topia.test.common.type");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_TYPE, Type.class, type);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setType(Type type) {
        Type oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public Type getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        Type result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_TYPE, this.type).
         toString();
        return result;
    }

} //ProductAbstract
