/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuiton.profiling.Counter;
import org.nuiton.profiling.Statistic;
import org.nuiton.profiling.Unit;

public class StatisticMethod
extends Statistic {
    String threadName;
    Method method;
    long callNestMethod;
    long totalNestMethod;
    Counter<Method> callers = new Counter();

    public StatisticMethod(Method method) {
        super(method.toString());
        this.method = method;
    }

    public StatisticMethod(String threadName, Method method) {
        this(method);
        this.threadName = threadName;
    }

    public void add(Method caller, long time, long nestTime, long nestCall) {
        super.add(time);
        this.callers.add(caller);
        this.callNestMethod += nestCall;
        this.totalNestMethod += nestTime;
    }

    @Override
    public String formatValue(long value) {
        String result = String.valueOf(Unit.Time.nano.convertTo(Unit.Time.s, value));
        return result;
    }

    @Override
    public StringBuilder exportCSV(StringBuilder result) {
        if (this.threadName != null) {
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(this.threadName).append(";");
        }
        result = super.exportCSV(result);
        result.append(";").append(this.callNestMethod);
        result.append(";").append(this.formatValue(this.totalNestMethod));
        result.append(";").append(this.callers);
        return result;
    }

    @Override
    public StringBuilder exportJSON(StringBuilder result) {
        result = super.exportJSON(result);
        result.deleteCharAt(result.length() - 1);
        if (this.threadName != null) {
            result.append(",").append("'thread':").append("'").append(this.threadName).append("'");
        }
        result.append(",").append("'method':").append("'").append(this.method).append("'").append(",");
        result.append("'call_nest':").append(this.callNestMethod).append(",");
        result.append("'total_with_nest':").append(this.formatValue(this.totalNestMethod));
        result.append(",").append("'callers': [");
        for (Map.Entry<Method, AtomicInteger> entry : this.callers) {
            result.append("{").append("'caller':").append("'").append(entry.getKey()).append("'").append(",").append("'call':").append(entry.getValue()).append("},");
        }
        result.append("]}");
        return result;
    }

    @Override
    public StringBuilder exportText(StringBuilder result) {
        if (this.threadName != null) {
            if (result == null) {
                result = new StringBuilder();
            }
            result.append("[").append(this.threadName).append("] ");
        }
        result = super.exportText(result);
        result.append(" call_nest: ").append(this.callNestMethod).append(" total_with_nest: ").append(this.formatValue(this.totalNestMethod));
        result.append(" callers: ").append(this.callers);
        return result;
    }
}

