/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

public class Statistic {
    String name;
    long call;
    long min = Long.MAX_VALUE;
    long max;
    long total;
    double delta = 0.0;
    double mean = 0.0;
    double M2 = 0.0;
    double lrTimeCall = 0.0;

    public Statistic(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void add(long value) {
        ++this.call;
        this.total += value;
        if (this.min > value) {
            this.min = value;
        }
        if (this.max < value) {
            this.max = value;
        }
        this.lrTimeCall += (double)(value * this.call);
        this.delta = (double)value - this.mean;
        this.mean += this.delta / (double)this.call;
        this.M2 += this.delta * ((double)value - this.mean);
    }

    public long getCall() {
        return this.call;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public double getMean() {
        double result = Double.NaN;
        try {
            result = this.total / this.call;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public double getStandardDeviation() {
        double variance = this.M2 / (double)Math.max(1L, this.call - 1L);
        double result = Math.sqrt(variance);
        return result;
    }

    public double getSlopeOfLinearRegression() {
        double result = Double.NaN;
        try {
            double mX = (this.call + 1L) / 2L;
            double mY = this.total / this.call;
            double mX2 = (this.call + 1L) * (2L * this.call + 1L) / 6L;
            double mXY = this.lrTimeCall / (double)this.call;
            result = (mXY - mX * mY) / (mX2 - mX * mX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String formatValue(long value) {
        String result = String.valueOf(value);
        return result;
    }

    public StringBuilder exportCSV(StringBuilder result) {
        if (result == null) {
            result = new StringBuilder();
        }
        result.append(this.getName()).append(";").append(this.call).append(";").append(this.formatValue(this.min)).append(";").append(this.formatValue((long)this.getMean())).append(";").append(this.formatValue(this.max)).append(";").append(this.formatValue(this.total)).append(";").append(this.formatValue((long)this.getStandardDeviation())).append(";").append(this.getSlopeOfLinearRegression());
        return result;
    }

    public StringBuilder exportJSON(StringBuilder result) {
        if (result == null) {
            result = new StringBuilder();
        }
        result.append("'").append(this.getName()).append("': {");
        result.append("'name':").append("'").append(this.getName()).append("'").append(",").append("'call':").append(this.call).append(",").append("'min':").append(this.formatValue(this.min)).append(",").append("'mean':").append(this.formatValue((long)this.getMean())).append(",").append("'max':").append(this.formatValue(this.max)).append(",").append("'total':").append(this.formatValue(this.total)).append(",").append("'deviation':").append(this.formatValue((long)this.getStandardDeviation())).append(",").append("'slope':").append(this.getSlopeOfLinearRegression());
        result.append("}");
        return result;
    }

    public StringBuilder exportText(StringBuilder result) {
        if (result == null) {
            result = new StringBuilder();
        }
        result.append(this.getName()).append("\t").append(" call: ").append(this.call).append(" min: ").append(this.formatValue(this.min)).append(" mean: ").append(this.formatValue((long)this.getMean())).append(" max: ").append(this.formatValue(this.max)).append(" total: ").append(this.formatValue(this.total)).append(" deviation: ").append(this.getStandardDeviation()).append(" slope: ").append(this.getSlopeOfLinearRegression());
        return result;
    }
}

