/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;

public class Play {
    public static void printBytes(byte[] bs) {
        StringBuilder sb = new StringBuilder("Bytes:" + bs.length + "[");
        int i = 0;
        while (i < bs.length) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(bs[i]);
            ++i;
        }
        sb.append("]");
        System.out.println(sb);
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            System.out.println("Specify a file");
            return;
        }
        if (!args[0].endsWith(".class")) {
            args[0] = String.valueOf(args[0]) + ".class";
        }
        FileInputStream fis = new FileInputStream(new File(args[0]));
        ClassParser cp = new ClassParser(fis, args[0]);
        JavaClass jc = cp.parse();
        Attribute[] attributes = jc.getAttributes();
        System.out.println("Methods");
        Method m = Play.getMethod("main", jc);
        System.out.println(m);
        Attribute attr = Play.getAttribute("LocalVariableTable", m);
        RuntimeVisAnnos rva = (RuntimeVisAnnos)attr;
        List<AnnotationGen> annoGens = rva.getAnnotations();
    }

    private static Attribute getAttribute(String string, Method m) {
        Attribute[] as = m.getAttributes();
        System.out.println(String.valueOf(as.length) + " attributes");
        int i = 0;
        while (i < as.length) {
            System.out.println(as[i].toString());
            if (as[i].getName().equals(string)) {
                return as[i];
            }
            ++i;
        }
        return null;
    }

    static Method getMethod(String name, JavaClass jc) {
        Method[] ms = jc.getMethods();
        if (ms != null) {
            Method[] methodArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals(name)) {
                    return m;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void printUsefulAttributes(Attribute[] attributes) {
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            String n3 = attribute.getName();
            if (n3.equals("RuntimeInvisibleTypeAnnotations") || n3.equals("RuntimeVisibleTypeAnnotations")) {
                Unknown unknown = (Unknown)attribute;
                byte[] bs = unknown.getBytes();
                Play.printBytes(bs);
            }
            ++n2;
        }
    }
}

