/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.sql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SqlFileReader
implements Iterable<String> {
    protected Reader source;

    public SqlFileReader(String source) {
        this.source = new StringReader(source);
    }

    public SqlFileReader(Reader source) {
        this.source = source;
    }

    @Override
    public Iterator<String> iterator() {
        return new SqlFileReaderIterator(this.source);
    }

    public static class SqlFileReaderIterator
    implements Iterator<String> {
        protected Reader source;
        protected StringBuilder buffer;
        protected int scanner;

        public SqlFileReaderIterator(Reader source) {
            this.source = source;
            this.buffer = new StringBuilder();
        }

        @Override
        public boolean hasNext() {
            return this.scanner != -1;
        }

        @Override
        public String next() {
            if (this.scanner == -1) {
                throw new NoSuchElementException();
            }
            SqlFileParserState state = SqlFileParserState.NORMAL;
            this.buffer.setLength(0);
            try {
                while ((this.scanner = this.source.read()) != -1) {
                    char character = (char)this.scanner;
                    block1 : switch (state) {
                        case NORMAL: {
                            switch (character) {
                                case '\n': 
                                case '\r': {
                                    break block1;
                                }
                                case ';': {
                                    this.buffer.append(";");
                                    return this.buffer.toString();
                                }
                                case '-': {
                                    int length = this.buffer.length();
                                    if (length != 0 && this.buffer.charAt(length - 1) == '-') {
                                        state = SqlFileParserState.COMMENT;
                                    }
                                    this.buffer.append(character);
                                    break block1;
                                }
                                case '\'': {
                                    state = SqlFileParserState.QUOTE;
                                    this.buffer.append(character);
                                    break block1;
                                }
                            }
                            this.buffer.append(character);
                            break;
                        }
                        case QUOTE: {
                            switch (character) {
                                case '\'': {
                                    state = SqlFileParserState.NORMAL;
                                    this.buffer.append(character);
                                    break block1;
                                }
                            }
                            this.buffer.append(character);
                            break;
                        }
                        case COMMENT: {
                            switch (character) {
                                case '\n': 
                                case '\r': {
                                    return this.buffer.toString();
                                }
                            }
                            this.buffer.append(character);
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return this.buffer.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    static enum SqlFileParserState {
        NORMAL,
        QUOTE,
        COMMENT;

    }
}

