/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.converter;

import java.lang.reflect.Method;
import java.util.ServiceLoader;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.converter.EnumConverter;

@Deprecated
public class ConverterUtil {
    private static final Log log = LogFactory.getLog(ConverterUtil.class);
    protected static final String CONVERTER_PACKAGE = "org.nuiton.util.converter";
    protected static Boolean WAS_INIT = Boolean.FALSE;

    public static <T> Converter getConverter(Class<T> type) {
        Converter converter;
        if (!WAS_INIT.booleanValue()) {
            ConverterUtil.initConverters();
        }
        if ((converter = ConvertUtils.lookup(type)) != null) {
            return converter;
        }
        if (type.isEnum()) {
            ConverterUtil.registerEnumConverter(type);
            return ConvertUtils.lookup(type);
        }
        try {
            ConverterUtil.registerConverter0(type);
            converter = ConvertUtils.lookup(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return converter;
    }

    public static <T> T convert(Class<T> type, Object toConvert) {
        if (!WAS_INIT.booleanValue()) {
            ConverterUtil.initConverters();
        }
        T result = null;
        Converter converter = ConverterUtil.getConverter(type);
        if (converter != null) {
            return (T)converter.convert(type, toConvert);
        }
        return result;
    }

    public static void registerConverter(Class<?> type) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (ConvertUtils.lookup(type) == null) {
            ConverterUtil.registerConverter0(type);
        }
    }

    protected static void registerConverter0(Class<?> type) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> aClass = Class.forName("org.nuiton.util.converter." + type.getSimpleName() + "Converter");
        Converter converter = (Converter)aClass.newInstance();
        log.info((Object)("for type : " + type + " : " + converter));
        ConvertUtils.register((Converter)converter, type);
    }

    public static void registerEnumConverter(Class<?> type, Object defaultValue) {
        if (EnumConverter.isEnabled(type, type) && ConvertUtils.lookup(type) == null) {
            EnumConverter converter = new EnumConverter(type, defaultValue);
            log.info((Object)("for type : " + type + " : " + converter));
            ConvertUtils.register((Converter)converter, type);
        }
    }

    public static void registerEnumConverter(Class<?> type) {
        ConverterUtil.registerEnumConverter(type, null);
    }

    public static byte[] convert(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    public static synchronized void deregister() {
        ConvertUtils.deregister();
        WAS_INIT = false;
    }

    public static synchronized void initConverters() {
        if (WAS_INIT != null && WAS_INIT.booleanValue()) {
            return;
        }
        ServiceLoader<Converter> converters = ServiceLoader.load(Converter.class);
        for (Converter converter : converters) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("discovered converter " + converter));
            }
            try {
                Method m = converter.getClass().getDeclaredMethod("getType", new Class[0]);
                m.setAccessible(true);
                try {
                    Class returnType = (Class)m.invoke((Object)converter, new Object[0]);
                    log.info((Object)("register converter " + converter));
                    ConvertUtils.register((Converter)converter, (Class)returnType);
                }
                catch (Exception ex) {
                    log.warn((Object)("could not obtain type of converter " + converter + " for reason : " + ex.getMessage()), (Throwable)ex);
                }
            }
            catch (NoSuchMethodException ex) {
                log.warn((Object)("could not find method getType on converter " + converter + ", will not be registred..."));
            }
            catch (SecurityException ex) {
                log.warn((Object)("could not find method getType on converter " + converter + ", will not be registred..."));
            }
        }
        WAS_INIT = true;
    }
}

