/*
 * *##% 
 * Maven License Plugin
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin.header.generator;

import java.io.IOException;

/**
 * A simple Contract to generate a new header for a given type of file.
 *
 * @author chemit
 * @since 1.0.0
 */
public interface HeaderGenerator {

    /**
     * Plexus role name
     */
    String ROLE_NAME = HeaderGenerator.class.getName();

    /**
     * 
     * @return the name of the generator
     */
    String getName();

    /**
     *
     * @return the description of the generator
     */
    String getDescription();

    /**
     * @param content the content to box.
     * @return the full header to add on the first line of file.
     */
    String getHeader(String content);

    /**
     *
     * @return the prefix to add on each lines of the header
     */
    String getLinePrefix();

    /**
     *
     * @param content
     * @return the prefix content
     * @throws IOException if any io exceptions
     */
    String prefixContent(String content) throws IOException;

    String getOpenTag();

    String getCloseTag();

    String getOpenProcessTag();

    String getCloseProcessTag();

    void setLinePrefix(String linePrefix);

    void setOpenTag(String openTag);

    void setCloseTag(String closeTag);

    void setOpenProcessTag(String openProcessTag);

    void setCloseProcessTag(String closeProcessTag);
}
