/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: RestDataNotFoundException.java 701 2010-04-15 14:01:44Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.7/src/main/java/org/nuiton/io/rest/RestDataNotFoundException.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

/**
 * Exception to be raised if a data does not exist ina 'askData' request, says
 * when the rest server returns a {@code 4XX} status code.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public class RestDataNotFoundException extends RestException {

    private static final long serialVersionUID = 1L;

    public RestDataNotFoundException() {
    }

    public RestDataNotFoundException(String message) {
        super(message);
    }

    public RestDataNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    public RestDataNotFoundException(Throwable cause) {
        super(cause);
    }
}
