/*
 * #%L
 * Maven helper plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 12:59:27 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 693 $
 * $Id: RestRequest.java 693 2010-04-12 10:59:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.3/src/main/java/org/nuiton/io/rest/RestRequest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

import java.io.File;
import java.util.Map;

/**
 * The contract of a rest request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public interface RestRequest {
    /** @return the splitted path to add to url */
    String[] getPath();

    /**
     * @return an array of pair (parameter name - parameter value) to pass
     *         to request
     */
    String[] getParameters();

    /** @return the map of attachment to pass to request */
    Map<String, File> getAttachments();
}
