/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: PluginWithEncoding.java 776 2010-10-23 11:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.10/src/main/java/org/nuiton/plugin/PluginWithEncoding.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.plugin;

/**
 * A common contract to be implements by our mojo and reports which needs encoding.
 * <p/>
 * Just expose a getter-setter {@link #getEncoding()} and {@link #setEncoding(String)}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2.6
 */
public interface PluginWithEncoding extends Plugin {


    /**
     * Gets the encoding to be used to read and write io resources.
     *
     * @return the encoding used.
     */
    String getEncoding();

    /**
     * Sets the encoding to use in mojo.
     *
     * @param encoding the new encoding to use in mojo
     */
    void setEncoding(String encoding);
}