/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.LicenseFactory;

import java.util.Map.Entry;

/**
 * Le goal pour afficher dans la console les differentes licenses connues.
 *
 * @author chemit
 * @goal available-licenses
 * @requiresProject false
 * @deprecated since 1.0.3, move all license stuff in maven-license-plugin (removed in 1.1.0)
 */
@Deprecated
public class AvailableLicensesPlugin extends AbstractMojo {

    /**
     * La baseURL d'un resolver de license supplementaire
     *
     * @parameter expression="${helper.extraResolver}"
     * @since 1.0.0
     */
    protected String extraResolver;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder sb = new StringBuilder();
        sb.append("Available licenses :\n");

        LicenseFactory factory = LicenseFactory.newInstance(extraResolver);

        for (Entry<String, String> license : factory.getLicenseNames().entrySet()) {
            sb.append(" * ").append(license.getKey()).append(" : ").append(license.getValue()).append('\n');
        }
        getLog().info(sb.toString());
    }

}
