/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton;

import java.io.ByteArrayInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.nuiton.plugin.Plugin;
import org.nuiton.util.MirroredFileUpdater;
import org.nuiton.util.PluginHelper;

/**
 * Un MOJO de base pour les autres MOJO concrets avec les options communes.
 *
 * @author chemit
 * @deprecated since 1.0.3, prefer use {@link org.nuiton.plugin.AbstractPlugin}
 */
@Deprecated
public abstract class AbstractPlugin extends AbstractMojo implements Plugin {

    protected abstract boolean ensurePackaging();

    /**
     * la methode qui est lancee au debut de la methode {@link #execute()} pour preparer l'init du goal.
     *
     * @return <code>true</code> if there is something to generate, <code>false</code> otherwise.
     * @throws Exception if any
     */
    protected abstract boolean init() throws Exception;

    /**
     * Do plugin action.
     * <p/>
     * The method {@link #execute()} invoke this method only and only if :
     * <ul>
     * <li>{@link #ensurePackaging()} returns <code>false</code> (filtrer project type, for example).</li>
     * <li>method {@link #init()} returns <code>true</code>.</li>
     * </ul>
     *
     * @throws Exception if any
     */
    protected abstract void doAction() throws Exception;
    protected final String skipAfterInitMessage;

    protected AbstractPlugin(String skipAfterInitMessage) {
        this.skipAfterInitMessage = skipAfterInitMessage;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {

            if (ensurePackaging()) {
                getLog().info("skip goal for packaging " + getProject().getPackaging());
                return;
            }

            boolean canContinue = init();

            if (!canContinue) {
                getLog().info(skipAfterInitMessage);
                return;
            }

            doAction();

        } catch (Exception e) {
            throw new MojoExecutionException("could not init goal " + getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
        }
    }

    /**
     * Does the actual copy of the file and logging.
     *
     * @param srcFile represents the file to copy.
     * @param destFile file name of destination file.
     *
     * @throws MojoExecutionException with a message if an
     *             error occurs.
     */
    protected void copyFile(File srcFile, File destFile)
            throws MojoExecutionException {
        try {
            getLog().info("Copying " + srcFile.getName() + " to " + destFile);

            FileUtils.copyFile(srcFile, destFile);

        } catch (Exception e) {
            throw new MojoExecutionException("Error copying from " + srcFile + " to " + destFile, e);
        }
    }

    /**
     * Does the actual copy of the content to a fileand logging.
     *
     * @param content represents the content to writeFile into file.
     * @param destFile file name of destination file.
     * @param encoding encoding to use to writeFile file
     * @throws MojoExecutionException with a message if an
     *             error occurs.
     */
    protected void copyFile(String content, File destFile, String encoding)
            throws MojoExecutionException {
        try {
            getLog().info("Copying content to " + destFile);

            InputStream in = new ByteArrayInputStream(content.getBytes(encoding));
            RawInputStreamFacade facade = new RawInputStreamFacade(in);

            FileUtils.copyStreamToFile(facade, destFile);

        } catch (Exception e) {
            throw new MojoExecutionException("Error copying content to " + destFile, e);
        }
    }

    public void writeFile(File destFile, String content, String encoding) throws IOException {
        PluginHelper.write(destFile, content, encoding);
    }

    /**
     * Test if a file exists and is newer than the pom file.
     *
     * @param f the file to test
     * @return <code>true</code> if file exists and is newer than the pom file,
     *         <code>false</code> otherwise.
     */
    protected boolean isFileNewerThanPomFile(File f) {
        File pomFile = getProject().getFile();
        return f.exists() && f.lastModified() > pomFile.lastModified();
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files, MirroredFileUpdater updater) {

        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);

        }
        for (String src : roots) {

            File f = new File(src);
            if (!f.exists()) {
                // do nothing on a non-existent
                continue;
            }

            if (isVerbose()) {
                getLog().info("discovering java source files in root " + src);
            }

            ds.setBasedir(f);
            // scan
            ds.scan();

            // get files
            String[] tmp = ds.getIncludedFiles();

            if (tmp.length < 1) {
                // no files found
                continue;
            }

            List<String> toTreate = new ArrayList<String>();

            if (updater != null) {
                updater.setSourceDirectory(f);
            }


            for (String filePath : tmp) {
                File srcFile = new File(f, filePath);
                // check file is up-to-date
                if (updater == null || !updater.isFileUpToDate(srcFile)) {
                    toTreate.add(filePath);
                }
            }


            if (toTreate.isEmpty()) {
                // no file or all are up-to-date
                continue;
            }

            // register files
            files.put(f, toTreate.toArray(new String[toTreate.size()]));

        }
    }

    protected Map<String, String> getFilesToTreate(String[] includes, String[] excludes, File srcDir, MirroredFileUpdater updater) {

        Map<String, String> result = new java.util.TreeMap<String, String>();

        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);

        }

        if (!srcDir.exists()) {
            // do nothing on a non-existent
            return result;
        }

        if (isVerbose()) {
            getLog().info("discovering files for " + srcDir);
        }

        ds.setBasedir(srcDir);
        // scan
        ds.scan();

        // get files
        String[] tmp = ds.getIncludedFiles();

        if (tmp.length < 1) {
            // no files found
            return result;
        }

        List<String> toTreate = new ArrayList<String>();

        if (updater != null) {
            updater.setSourceDirectory(srcDir);
        }

        for (String filePath : tmp) {
            File srcFile = new File(srcDir, filePath);
            File mirrorFile = updater.getMirrorFile(srcFile);
            // check file is up-to-date
            if (updater == null || !updater.isFileUpToDate(srcFile)) {
                result.put(filePath, mirrorFile.getAbsolutePath());
                toTreate.add(filePath);
            }
        }


        if (toTreate.isEmpty()) {
            // no file or all are up-to-date
            return result;
        }

        // register files
        return result;
    }

    protected void addCompileSourceRoots(File srcDir) {
        if (!getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (isVerbose()) {
                getLog().info("adding source roots : " + srcDir.getPath());
            }
            getProject().addCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeCompileSourceRoots(File srcDir) {
        if (getProject().getCompileSourceRoots().contains(srcDir.getPath())) {
            if (isVerbose()) {
                getLog().info("removing source roots : " + srcDir.getPath());
            }
            getProject().getCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addTestCompileSourceRoots(File srcDir) {
        if (!getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (isVerbose()) {
                getLog().info("adding test source roots : " + srcDir.getPath());
            }
            getProject().addTestCompileSourceRoot(srcDir.getPath());
        }
    }

    protected void removeTestCompileSourceRoots(File srcDir) {
        if (getProject().getTestCompileSourceRoots().contains(srcDir.getPath())) {
            if (isVerbose()) {
                getLog().info("removing test source roots : " + srcDir.getPath());
            }
            getProject().getTestCompileSourceRoots().remove(srcDir.getPath());
        }
    }

    protected void addResourceDir(String dir) {
        boolean added = PluginHelper.addResourceDir(dir, getProject());
        if (added) {
            getLog().info("add resource " + dir);
        }
    }

    protected void addTestResourceDir(String dir) {
        boolean added = PluginHelper.addTestResourceDir(dir, getProject());
        if (added) {
            getLog().info("add test resource " + dir);
        }
    }

    @SuppressWarnings({"unchecked"})
    protected URLClassLoader initClassLoader(MavenProject project, File src, boolean addSourcesToClassPath, boolean testPhase, boolean addResourcesToClassPath, boolean addCompileClassPath, boolean addProjectClassPath) throws MalformedURLException {
        URLClassLoader loader = null;
        if (project != null) {

            URLClassLoader result;
            try {

                List<URL> lUrls = new ArrayList<URL>();
                List<String> sources = project.getCompileSourceRoots();

                if (addSourcesToClassPath) {
                    for (String source : sources) {
                        lUrls.add(new File(source).toURI().toURL());
                    }
                    if (testPhase) {
                        for (Object source : project.getTestCompileSourceRoots()) {
                            lUrls.add(new File(source.toString()).toURI().toURL());
                        }
                    }
                }
                if (addResourcesToClassPath) {
                    for (Object source : project.getResources()) {
                        Resource r = (Resource) source;
                        lUrls.add(new File(r.getDirectory()).toURI().toURL());
                    }
                }
                if (testPhase && addCompileClassPath) {
                    if (project != null) {
                        lUrls.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
                    }
                }
                if (src != null) {
                    lUrls.add(src.toURI().toURL());
                }
                if (addProjectClassPath) {
                    getLog().info("use project compile scope class-path");
                    // add also all dependencies of the project in compile scope
                    Set<?> artifacts = project.getArtifacts();
                    for (Object o : artifacts) {
                        Artifact a = (Artifact) o;
                        lUrls.add(a.getFile().toURI().toURL());
                    }
                }

                result = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), getClass().getClassLoader());

            } catch (IOException e) {
                throw new RuntimeException("Can't create ClassLoader for reason " + e.getMessage(), e);
            }
            loader = result;
        } else {
            List<URL> lUrls = new ArrayList<URL>();
            if (addSourcesToClassPath) {
                lUrls.add(src.toURI().toURL());
            }
            loader = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), getClass().getClassLoader());
        }
        if (isVerbose()) {
            for (URL entry : loader.getURLs()) {
                getLog().info("classpath : " + entry);
            }
        }
        return loader;
    }

    /**
     *
     * @param f le fichier de template
     * @return l'url du fichier demande
     * @throws IOException pour toute erreur de recherche
     */
    protected URL getTemplate(File f) throws IOException {
        URL r = null;
        if (f.exists()) {
            r = f.toURI().toURL();
        } else {
            r = getClass().getResource(f.toString());
        }
        return r;
    }

    /**
     * Vérifie que le fichier donné existe bien (sur le filesystem ou
     * dans le class-path).
     * 
     * @param f le fichier que l'on veut vérifié
     * @throws IOException pour tout erreur de recherche
     */
    protected void checkResource(File f) throws IOException {
        if (!f.exists()) {
            // test in classPath
            InputStream r = null;
            try {
                r = getClass().getResourceAsStream(f.toString());
                if (r == null) {
                    throw new IOException("could not find ressource " + f);
                }
            } finally {
                if (r != null) {
                    r.close();
                }
            }
        }
    }
}
