/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.util.FileUpdaterHelper;
import org.nuiton.util.JavaDummy;
import org.nuiton.util.MirroredFileUpdater;

public class JavaFileUpdaterTest {
    private static final Log log = LogFactory.getLog(FileUpdaterHelper.class);
    static final char SEP = File.separatorChar;
    static MirroredFileUpdater fileUpdater;
    static File sourceFile;
    static File mirrorFile;

    @BeforeClass
    public static void initClass() throws Exception {
        String basedir = System.getProperty("basedir");
        if (basedir == null) {
            log.warn((Object)"basedir not found, test is not executed from maven...");
            basedir = new File(new File("").getAbsolutePath()).getAbsolutePath();
        }
        log.info((Object)("basedir = " + basedir));
        File src = new File(basedir, "src" + SEP + "test" + SEP + "java");
        File dir = new File(basedir, "target" + SEP + "test-classes");
        fileUpdater = FileUpdaterHelper.newJavaFileUpdater((File)src, (File)dir);
        log.info((Object)fileUpdater);
        File sourceDirectory = fileUpdater.getSourceDirectory();
        Assert.assertTrue((String)"sourcedir is null", (sourceDirectory != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("sourcedir does not exists " + sourceDirectory), (boolean)sourceDirectory.exists());
        File destinationDirectory = fileUpdater.getDestinationDirectory();
        Assert.assertTrue((String)"destinationDirectory  is null", (destinationDirectory != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("destinationDirectory  does not exists " + destinationDirectory), (boolean)destinationDirectory.exists());
        sourceFile = new File(fileUpdater.getSourceDirectory(), "org" + SEP + "nuiton" + SEP + "util" + SEP + JavaDummy.class.getSimpleName() + ".java");
    }

    @Test
    public void testSourceFileIsUptoDate() throws Exception {
        Assert.assertTrue((String)"fileUpdater was not init", (fileUpdater != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"sourceFile was not init ", (sourceFile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("could not find source of this test " + sourceFile), (boolean)sourceFile.exists());
        Assert.assertTrue((String)(sourceFile + " should be uptodate"), (boolean)fileUpdater.isFileUpToDate(sourceFile));
        mirrorFile = fileUpdater.getMirrorFile(sourceFile);
    }

    @Test
    public void testSourceFileDoesNotHaveMirrorFile() throws Exception {
        Assert.assertTrue((String)"fileUpdater was not init", (fileUpdater != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"sourceFile was not init ", (sourceFile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("could not find source of this test " + sourceFile), (boolean)sourceFile.exists());
        Assert.assertTrue((String)"mirrorFile was not init ", (mirrorFile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("could not find mirrorFile " + mirrorFile), (boolean)mirrorFile.exists());
        File mirrorClassRenamed = new File(fileUpdater.getMirrorFile(sourceFile).getAbsolutePath() + "2");
        mirrorFile.renameTo(mirrorClassRenamed);
        Assert.assertFalse((String)(sourceFile + " should not be uptodate"), (boolean)fileUpdater.isFileUpToDate(sourceFile));
        mirrorClassRenamed.renameTo(mirrorFile);
        Assert.assertTrue((String)(sourceFile + " should be uptodate"), (boolean)fileUpdater.isFileUpToDate(sourceFile));
    }

    @Test
    public void testSourceFileIsNewerThanMirrorFile() throws Exception {
        Assert.assertTrue((String)"fileUpdater was not init", (fileUpdater != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"sourceFile was not init ", (sourceFile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("could not find source of this test " + sourceFile), (boolean)sourceFile.exists());
        Assert.assertTrue((String)"mirrorFile was not init ", (mirrorFile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("could not find mirrorFile " + mirrorFile), (boolean)mirrorFile.exists());
        long sourceTime = sourceFile.lastModified();
        long mirrorTime = mirrorFile.lastModified();
        sourceFile.setLastModified(mirrorTime + 10L);
        Assert.assertFalse((String)(sourceFile + " should not be uptodate"), (boolean)fileUpdater.isFileUpToDate(sourceFile));
        sourceFile.setLastModified(sourceTime);
        Assert.assertTrue((String)(sourceFile + " should be uptodate"), (boolean)fileUpdater.isFileUpToDate(sourceFile));
    }
}

