/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/**
 * Check that :
 *
 * 1) the changelog exists on standalone module or root module of a
 * multi-module project.
 * 2) any project module has a README.txt and LICENSE.txt file
 * 
 * @goal check-project-files
 * @requiresProject true
 * @phase validate
 * @author chemit
 * @since 1.0.2
 */
public class CheckProjectFilesPlugin extends AbstractMojo {

    /**
     * Dependance du projet.
     *
     * @parameter default-value="${project}"
     * @required
     * @since 1.0.2
     */
    protected MavenProject project;
    /**
     * Un flag pour activer le mode verbeux.
     *
     * @parameter expression="${helper.verbose}"  default-value="${maven.verbose}"
     * @since 1.0.2
     */
    protected boolean verbose;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        checkChangelogFile();
        checkReadmeFile();
        checkLicenseFile();
    }

    protected void checkChangelogFile() throws MojoExecutionException {
        if (project.isExecutionRoot()) {
            File f = new File(project.getBasedir(), "changelog.txt");
            if (!f.exists()) {
                throw new MojoExecutionException("the module " + project.getName() + " requires the file " + f.getAbsolutePath());
            } else {
                if (verbose) {
                    getLog().info("changelog file dectected : " + f.getAbsolutePath());
                }
            }
        } else {
            getLog().info("changelog.txt is not required for module " + project.getName() + " (not a root module)");
        }
    }

    protected void checkReadmeFile() throws MojoExecutionException {
        File f = new File(project.getBasedir(), "README.txt");
        if (!f.exists()) {
            throw new MojoExecutionException("the module " + project.getName() + " requires the file " + f.getAbsolutePath());
        } else {
            if (verbose) {
                getLog().info("readme file dectected : " + f.getAbsolutePath());
            }
        }
    }

    protected void checkLicenseFile() throws MojoExecutionException {
        File f = new File(project.getBasedir(), "LICENSE.txt");
        if (!f.exists()) {
            throw new MojoExecutionException("the module " + project.getName() + " requires the file " + f.getAbsolutePath());
        } else {
            if (verbose) {
                getLog().info("license file dectected : " + f.getAbsolutePath());
            }
        }
    }
}
