/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.io.File;
import java.util.Map;
import org.junit.Test;
import org.nuiton.license.BaseLicenseTestCase;
import org.nuiton.license.JarLicenseResolver;
import org.nuiton.license.LicenseFactory;
import org.nuiton.license.LicenseResolver;

public class LicenseFactoryTest
extends BaseLicenseTestCase {
    @Test
    public void testNewInstance() throws Exception {
        LicenseFactory factory = LicenseFactory.newInstance((String[])new String[0]);
        LicenseFactoryTest.assertNotNull((Object)factory);
        LicenseFactoryTest.assertEquals((long)1L, (long)factory.resolvers.size());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(0));
        LicenseFactoryTest.assertEquals(JarLicenseResolver.class, ((LicenseResolver)factory.resolvers.get(0)).getClass());
        factory = LicenseFactory.newInstance((String[])new String[]{""});
        LicenseFactoryTest.assertNotNull((Object)factory);
        LicenseFactoryTest.assertEquals((long)1L, (long)factory.resolvers.size());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(0));
        LicenseFactoryTest.assertEquals(JarLicenseResolver.class, ((LicenseResolver)factory.resolvers.get(0)).getClass());
        factory = LicenseFactory.newInstance((String[])new String[]{"yo"});
        LicenseFactoryTest.assertNotNull((Object)factory);
        LicenseFactoryTest.assertEquals((long)2L, (long)factory.resolvers.size());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(0));
        LicenseFactoryTest.assertEquals(JarLicenseResolver.class, ((LicenseResolver)factory.resolvers.get(0)).getClass());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(1));
        LicenseFactoryTest.assertEquals(LicenseResolver.class, ((LicenseResolver)factory.resolvers.get(1)).getClass());
        LicenseFactoryTest.assertEquals((Object)"yo", (Object)((LicenseResolver)factory.resolvers.get(1)).getBaseURL());
        factory.addResolver(new LicenseResolver("yo2"));
        LicenseFactoryTest.assertEquals((long)3L, (long)factory.resolvers.size());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(0));
        LicenseFactoryTest.assertEquals(JarLicenseResolver.class, ((LicenseResolver)factory.resolvers.get(0)).getClass());
        LicenseFactoryTest.assertNotNull(factory.resolvers.get(1));
        LicenseFactoryTest.assertEquals(LicenseResolver.class, ((LicenseResolver)factory.resolvers.get(1)).getClass());
        LicenseFactoryTest.assertEquals((Object)"yo", (Object)((LicenseResolver)factory.resolvers.get(1)).getBaseURL());
        LicenseFactoryTest.assertEquals(LicenseResolver.class, ((LicenseResolver)factory.resolvers.get(2)).getClass());
        LicenseFactoryTest.assertEquals((Object)"yo2", (Object)((LicenseResolver)factory.resolvers.get(2)).getBaseURL());
    }

    @Test
    public void testGetLicenseNames() throws Exception {
        LicenseFactory factory = LicenseFactory.newInstance((String[])new String[0]);
        int expectedJarResolverLicenses = 5;
        Map licenseNames = factory.getLicenseNames();
        LicenseFactoryTest.assertEquals((long)expectedJarResolverLicenses, (long)licenseNames.size());
        File repo = this.createLicenseRepository(true);
        LicenseResolver resolver = new LicenseResolver();
        resolver.setBaseURL(repo.toURI().toURL().toString());
        factory.addResolver(resolver);
        licenseNames = factory.getLicenseNames();
        LicenseFactoryTest.assertEquals((long)(expectedJarResolverLicenses + 1), (long)licenseNames.size());
        long timestamp = System.currentTimeMillis();
        String licenseName = "dummy2_" + timestamp;
        this.addLicenseToRepository(repo, licenseName);
        factory = LicenseFactory.newInstance((String[])new String[]{repo.toURI().toURL().toString()});
        licenseNames = factory.getLicenseNames();
        LicenseFactoryTest.assertEquals((long)(expectedJarResolverLicenses + 2), (long)licenseNames.size());
    }
}

