/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.jaxx.plugin.AbstractGenerateHelpMojo;

public class GenerateHelpIdsMojo
extends AbstractGenerateHelpMojo {
    @Override
    public boolean init() throws Exception {
        if (!this.generateHelp) {
            return true;
        }
        if (!super.init()) {
            return false;
        }
        if (this.getHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        if (this.getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStoreAll' property.");
        }
        return true;
    }

    @Override
    public void doAction() throws Exception {
        if (this.skipAction()) {
            return;
        }
        Set helpIds = HelpRootCompiledObjectDecorator.getHelpIds();
        if (helpIds.isEmpty()) {
            this.getLog().info((CharSequence)"No helpIds detected.");
            this.cleanHelpIdsStore();
            return;
        }
        File idsStore = this.getHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Store detected help ids to " + idsStore));
        this.storeHelpIds(idsStore, helpIds);
        File idsStoreAll = this.getMergeHelpIdsStoreFile();
        this.getLog().info((CharSequence)("Merge help ids to " + idsStoreAll));
        if (idsStoreAll.exists()) {
            Set<String> allIds = this.loadHelpIds(idsStoreAll);
            helpIds.addAll(allIds);
            allIds.clear();
        }
        this.storeHelpIds(idsStoreAll, helpIds);
        helpIds.clear();
    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File source, String localePath) throws Exception {
    }

    @Override
    protected void postDoAction() {
    }

    @Override
    public File getTargetDirectory() {
        return this.getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.setOutputHelpIds(targetDirectory);
    }
}

