package org.nuiton.jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import static org.nuiton.i18n.I18n.t;

public class FontSizor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DEFAULT_FONT_SIZE = "defaultFontSize";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_SHOW_DEFAULT_FONT_SIZE = "showDefaultFontSize";
    public static final String PROPERTY_SHOW_FONT_SIZE = "showFontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEFAULT_SIZE_ENABLED = "defaultSize.enabled";
    public static final String BINDING_DEFAULT_SIZE_VISIBLE = "defaultSize.visible";
    public static final String BINDING_DOWN_SIZE_ENABLED = "downSize.enabled";
    public static final String BINDING_UP_SIZE_ENABLED = "upSize.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String BINDING_$JTOOL_BAR0_OPAQUE = "$JToolBar0.opaque";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUTU8TQRjHp5W2tAURMCSaaIhUMUF3fYkXIb4AaYBUMJYDsTFx2p3SJcvMMDtLFw8cPHjzC3jw6sXwHYgnEy9e+Q4mfASf2d12wXS3K+1h284+z2/+z+v3PyhjC3SPiW2NOqZkVNvBrqsJh0pzl2hrL7e2Nuo7pCGXid0QJpdMIP+TSqN0DRWN7rktkVarAEn3Sboi6QFJX2K7nFFCz4DmK6hgywOL2C1CpER3I50btq1Xu5bzLndEcFdP1b3u+vXp4UmKLH9JI+RykF+EsOf+AxBGPVRBadOQaKKyg/exbmG6DeKESbchoFF1tmRh217Hu2QPHaJcBWU5FgCT6P6F0uPhPJTLJRourb3GlFgPJJqN0m+3QY1WZlRWzQ9McO65ZyXKtTA1LCKgVAl9V3yHEDFmkCZ2LBlYEDhRMWsqD1rZYliGtsPNwEj9Hw/PJ+0Way//yxkPOYuMWQTT0GNEeZTP0KbCd4XS2ibYL2IBObmqIG4QRedcGeZDVQZrU//KyXPWi46EdCira13jYhBu596b519nHR7xBupUwXWvThPnbvFOA1uB7kTVAXpeC3s+bL9UDWWEA8cSzUSPm5qYN2Dlz8pM9KyoazzDj0eH4lv79KQzIFMgbrqf15ldAN3KBePQW6bSNuZPhyNNS3+F+XwN5W1iwSLxFsVsvPJqYAnqQYXfF4qkrWC7BbRM7uT4x9T735dQuowK0HNGGSv7VZSXLQEZY5bh8ucvPHEj7WF4XlEyoV4WPmBQZnR5wcAST9dNakBVnrmQpdn4LHVFHW2c/vz6+fZxJ1Mp0FhK4hlmK/MWZU1qmZR4yyTYEz2XR5HbxDFYuAR6rYWU+i7wYCbmvKfeK/7ROhMGEa+xSSVRS2zBlzGNJaywuiMJpEJ5P/YCU7+eePDrCeD5php/XLc87U8vDsoyjvccj/Lo4pQhs+FPcwTjRgJGjlAVjzEgZqTJGo4dZD0mOUlYeY/VJ8tJQEUJ23HT5JvElQOh1PFqTIamExHWByZUY6JIRtgamPBuIAI03L5pm0FtB0pGXEFuDVyQZIS4giQjxBUkGSGuIP0JsEVkMB4RmSglUrHfh/AXKY+6rokLAAA=";
    private static final Log log = LogFactory.getLog(FontSizor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Float defaultFontSize;
    protected JButton defaultSize;
    protected JButton downSize;
    protected Float fontSize;
    protected FontSizorHandler handler;
    protected Boolean showDefaultFontSize;
    protected Boolean showFontSize;
    protected JButton upSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private FontSizor $JPanel0;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init();
    }
    
    boolean updateDefaultSizeEnabled(Float fontSize, Float defaultFontSize, boolean enabled) {
       return handler.updateDefaultSizeEnabled( fontSize,defaultFontSize, enabled);
    }
    
    public void setCallBack(Runnable action) {
        handler.setCallBack(action);
    }
    
    void $afterCompleteSetup() {
        handler.$afterCompleteSetup();    
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FontSizor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor() {
        $initialize();
    }

    public FontSizor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor(boolean param0) {
        super(param0);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__defaultSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(defaultFontSize);
    }

    public void doActionPerformed__on__downSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(fontSize - 1);
    }

    public void doActionPerformed__on__upSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(fontSize + 1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Float getDefaultFontSize() {
        return defaultFontSize;
    }

    public JButton getDefaultSize() {
        return defaultSize;
    }

    public JButton getDownSize() {
        return downSize;
    }

    public Float getFontSize() {
        return fontSize;
    }

    public FontSizorHandler getHandler() {
        return handler;
    }

    public Boolean getShowDefaultFontSize() {
        return showDefaultFontSize;
    }

    public Boolean getShowFontSize() {
        return showFontSize;
    }

    public JButton getUpSize() {
        return upSize;
    }

    public Boolean isShowDefaultFontSize() {
        return showDefaultFontSize !=null && showDefaultFontSize;
    }

    public Boolean isShowFontSize() {
        return showFontSize !=null && showFontSize;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDefaultFontSize(Float defaultFontSize) {
        Float oldValue = this.defaultFontSize;
        this.defaultFontSize = defaultFontSize;
        firePropertyChange(PROPERTY_DEFAULT_FONT_SIZE, oldValue, defaultFontSize);
    }

    public void setFontSize(Float fontSize) {
        Float oldValue = this.fontSize;
        this.fontSize = fontSize;
        firePropertyChange(PROPERTY_FONT_SIZE, oldValue, fontSize);
    }

    public void setShowDefaultFontSize(Boolean showDefaultFontSize) {
        Boolean oldValue = this.showDefaultFontSize;
        this.showDefaultFontSize = showDefaultFontSize;
        firePropertyChange(PROPERTY_SHOW_DEFAULT_FONT_SIZE, oldValue, showDefaultFontSize);
    }

    public void setShowFontSize(Boolean showFontSize) {
        Boolean oldValue = this.showFontSize;
        this.showFontSize = showFontSize;
        firePropertyChange(PROPERTY_SHOW_FONT_SIZE, oldValue, showFontSize);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDefaultFontSize() {
        $objectMap.put("defaultFontSize", defaultFontSize = 12f);
    }

    protected void createDefaultSize() {
        $objectMap.put("defaultSize", defaultSize = new JButton());
        
        defaultSize.setName("defaultSize");
        defaultSize.setFocusPainted(false);
        defaultSize.setFocusable(false);
        defaultSize.setToolTipText(t("fontsize.action.default.tip"));
        defaultSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__defaultSize"));
    }

    protected void createDownSize() {
        $objectMap.put("downSize", downSize = new JButton());
        
        downSize.setName("downSize");
        downSize.setFocusPainted(false);
        downSize.setFocusable(false);
        downSize.setToolTipText(t("fontsize.action.down.tip"));
        downSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downSize"));
    }

    protected void createFontSize() {
        $objectMap.put("fontSize", fontSize = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FontSizorHandler(this));
    }

    protected void createShowDefaultFontSize() {
        $objectMap.put("showDefaultFontSize", showDefaultFontSize = true);
    }

    protected void createShowFontSize() {
        $objectMap.put("showFontSize", showFontSize = false);
    }

    protected void createUpSize() {
        $objectMap.put("upSize", upSize = new JButton());
        
        upSize.setName("upSize");
        upSize.setFocusPainted(false);
        upSize.setFocusable(false);
        upSize.setToolTipText(t("fontsize.action.up.tip"));
        upSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__upSize"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createDefaultFontSize();
        createFontSize();
        createShowDefaultFontSize();
        createShowFontSize();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        createDownSize();
        createDefaultSize();
        createUpSize();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_OPAQUE, true ,"opaque") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setOpaque(isOpaque());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DOWN_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                downSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_ENABLED, true ,"fontSize" ,"defaultFontSize" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setEnabled(updateDefaultSizeEnabled(getFontSize(), getDefaultFontSize(), isEnabled()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_VISIBLE, true ,"showDefaultFontSize") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setVisible(isShowDefaultFontSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UP_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                upSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"fontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(SwingUtil.getStringValue(getFontSize())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"showFontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isShowFontSize());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.CENTER);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(downSize);
        $JToolBar0.add(defaultSize);
        $JToolBar0.add(upSize);
        $JToolBar0.add($JLabel0);
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 property setters
        downSize.setIcon(SwingUtil.createActionIcon("font-size-down"));
        defaultSize.setIcon(SwingUtil.createActionIcon("font-size"));
        upSize.setIcon(SwingUtil.createActionIcon("font-size-up"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}