/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Color;
import javax.swing.Timer;
import jaxx.runtime.swing.StatusMessagePanel;

public class StatusMessagePanelHandler {
    protected Color statusForeground = null;
    protected String statusReferenceContent = null;
    protected Timer timer = null;

    protected void fadeStatus(StatusMessagePanel ui) {
        for (int i = 0; i < 8; ++i) {
            if (!this.statusReferenceContent.equals(ui.getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = ui.getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(), currentForeground.getGreen(), currentForeground.getBlue(), currentForeground.getAlpha() - 25);
            ui.getStatusLabel().setForeground(newColor);
            ui.getStatusLabel().repaint();
        }
    }

    protected void startStatusFader(StatusMessagePanel ui) {
        this.statusReferenceContent = ui.getStatusLabel().getText();
        int millisecondsPerMinute = 5000;
        this.timer = new Timer(millisecondsPerMinute, ui);
        this.timer.setRepeats(false);
        this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
        this.timer.start();
    }

    protected void stopStatusFader(StatusMessagePanel ui) {
        if (this.timer != null) {
            this.timer.stop();
            ui.getStatusLabel().setForeground(this.statusForeground);
        }
    }
}

