/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config.model;

import javax.swing.table.TableCellEditor;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

public class ConfigUIModelBuilder {
    private static final Log log = LogFactory.getLog(ConfigUIModelBuilder.class);
    ConfigUIModel model;
    CategoryModel category;
    OptionModel option;

    public void createModel(ApplicationConfig config) throws IllegalStateException, NullPointerException {
        this.checkNoCurrent(this.model, "model");
        this.checkNotNull(config, "createModel", "config");
        this.model = new ConfigUIModel(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("model created : " + this.model));
        }
    }

    public void setReloadApplicationCallback(Runnable callback) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(callback, "setReloadApplicationCallback", "callback");
        this.model.setReloadApplicationCallback(callback);
    }

    public void setReloadUICallback(Runnable callback) {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(callback, "setReloadUICallback", "callback");
        this.model.setReloadUICallback(callback);
    }

    public void addCategory(String categoryName, String categoryLabel) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkNotNull(categoryName, "addCategory", "categoryName");
        this.checkNotNull(categoryLabel, "addCategory", "categoryLabel");
        this.flushCategory();
        this.category = new CategoryModel(categoryName, categoryLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("category created : " + this.category));
        }
    }

    public void addOption(ApplicationConfig.OptionDef def) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.model, "model");
        this.checkCurrent(this.category, "category");
        this.checkNotNull(def, "addOption", "def");
        this.flushOption();
        Object value = this.model.getConfig().getOption(def);
        this.option = new OptionModel(def, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("option created : " + this.option));
        }
    }

    public void addOption(ApplicationConfig.OptionDef def, String propertyName) throws IllegalStateException, NullPointerException {
        this.addOption(def);
        this.checkNotNull(propertyName, "setOptionPropertyName", "propertyName");
        this.option.setPropertyName(propertyName);
    }

    public void setOptionPropertyName(String propertyName) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(propertyName, "setOptionPropertyName", "propertyName");
        this.option.setPropertyName(propertyName);
    }

    public void setOptionEditor(TableCellEditor editor) throws IllegalStateException, NullPointerException {
        this.checkCurrent(this.option, "option");
        this.checkNotNull(editor, "setOptionEditor", "editor");
        this.option.setEditor(editor);
    }

    public void setOptionNeedReloadUI(boolean needReload) throws IllegalStateException {
        this.checkCurrent(this.option, "option");
        this.option.setNeedReloadUI(needReload);
    }

    public void setOptionNeedReloadApplication(boolean needReload) throws IllegalStateException {
        this.checkCurrent(this.option, "option");
        this.option.setNeedReloadApplication(needReload);
    }

    public ConfigUIModel flushModel() throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.flushCategory();
        ConfigUIModel result = this.model;
        this.model = null;
        return result;
    }

    public void setModel(ConfigUIModel model) throws IllegalStateException {
        this.checkNoCurrent(model, "model");
        this.model = model;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current model : " + this.model));
        }
        this.category = null;
        this.option = null;
    }

    public void setCategory(CategoryModel categoryModel) throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.checkNoCurrent(this.category, "category");
        this.category = categoryModel;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current category : " + this.category));
        }
        this.option = null;
    }

    public void setOption(OptionModel optionModel) throws IllegalStateException {
        this.checkCurrent(this.model, "model");
        this.checkCurrent(this.category, "category");
        this.checkNoCurrent(this.option, "option");
        this.option = optionModel;
        if (log.isDebugEnabled()) {
            log.debug((Object)("new current option : " + this.option));
        }
    }

    protected CategoryModel flushCategory() {
        CategoryModel result = this.category;
        if (this.category != null) {
            this.flushOption();
            this.model.addCategory(this.category);
            this.category = null;
        }
        return result;
    }

    protected OptionModel flushOption() {
        OptionModel result = this.option;
        if (this.option != null) {
            this.category.addOption(this.option);
            this.option = null;
        }
        return result;
    }

    protected void checkCurrent(Object o, String type) {
        if (o == null) {
            throw new IllegalStateException("no current " + type + "!");
        }
    }

    protected void checkNoCurrent(Object o, String type) {
        if (o != null) {
            throw new IllegalStateException("there is already a current " + type + "!");
        }
    }

    protected void checkNotNull(Object o, String method, String parameter) {
        if (o == null) {
            throw new NullPointerException("method " + method + " does not support null parameter " + parameter + "!");
        }
    }
}

