/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import jaxx.runtime.swing.editor.TimeEditor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeEditorHandler {
    public static final Log log = LogFactory.getLog(TimeEditorHandler.class);
    public static final String BEAN_PROPERTY = "bean";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String DATE_PROPERTY = "date";
    public static final String TIME_MODEL_PROPERTY = "timeModel";
    protected TimeEditor editor;
    protected Method mutator;
    protected Calendar calendar;

    public TimeEditorHandler(TimeEditor ui) {
        this.editor = ui;
        this.calendar = Calendar.getInstance();
    }

    public void init() {
        if (this.editor.getBean() == null) {
            throw new NullPointerException("can not have a null bean in ui " + this.editor);
        }
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 25; i += 2) {
            labelTable.put(i * 60, new JLabel(i + ""));
        }
        JSlider slider = this.editor.getSlider();
        slider.setLabelTable(labelTable);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int value = this.getSliderValue(e);
                JSlider slider = (JSlider)e.getComponent();
                slider.setValueIsAdjusting(true);
                slider.setValue(value);
                slider.setValueIsAdjusting(false);
                this.showToolTip(e);
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showToolTip(e);
            }

            int getSliderValue(MouseEvent e) {
                JSlider slider = (JSlider)e.getSource();
                int value = -1;
                if (slider.getUI() instanceof BasicSliderUI) {
                    BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                    value = slider.getOrientation() == 0 ? ui.valueForXPosition(e.getX()) : ui.valueForYPosition(e.getY());
                }
                return value;
            }

            void showToolTip(MouseEvent e) {
                int value = this.getSliderValue(e);
                if (value == -1) {
                    return;
                }
                int h = value / 60;
                int m = value % 60;
                String text = "";
                if (h < 10) {
                    text = "0";
                }
                text = text + h + " : ";
                if (m < 10) {
                    text = text + "0";
                }
                text = text + m;
                JSlider slider = (JSlider)e.getSource();
                slider.setToolTipText(text);
            }
        };
        slider.addMouseListener(m);
        slider.addMouseMotionListener(m);
        this.editor.addPropertyChangeListener(DATE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date date = (Date)evt.getNewValue();
                if (date == null) {
                    return;
                }
                TimeEditorHandler.this.calendar.setTime(date);
                int hours = TimeEditorHandler.this.calendar.get(11);
                int minutes = TimeEditorHandler.this.calendar.get(12);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("date changed : new value " + hours + ":" + minutes));
                }
                TimeEditorHandler.this.getEditor().setTimeModel(hours * 60 + minutes);
            }
        });
        this.editor.addPropertyChangeListener(TIME_MODEL_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer time = (Integer)evt.getNewValue();
                int hours = time / 60;
                int minutes = time % 60;
                TimeEditorHandler.this.calendar.set(11, hours);
                TimeEditorHandler.this.calendar.set(12, minutes);
                TimeEditorHandler.this.setDate(null, TimeEditorHandler.this.calendar.getTime());
            }
        });
    }

    public TimeEditor getEditor() {
        return this.editor;
    }

    protected void setDate(Date oldValue, Date newValue) {
        if (this.editor.getBean() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.editor.getProperty() + " on " + this.editor.getBean().getClass() + " :: " + oldValue + " to " + newValue));
        }
        try {
            this.getMutator().invoke(this.editor.getBean(), newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Method getMutator() {
        if (this.mutator == null) {
            Object bean = this.editor.getBean();
            if (bean == null) {
                throw new NullPointerException("could not find bean in " + this.editor);
            }
            String property = this.editor.getProperty();
            if (property == null) {
                throw new NullPointerException("could not find property in " + this.editor);
            }
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
                this.mutator = descriptor.getWriteMethod();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.mutator;
    }
}

