/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util.config;

import java.util.EnumSet;
import org.nuiton.jaxx.util.DialogUIModel;
import org.nuiton.util.config.Config;

public abstract class DialogConfigUIModel<E extends Enum<E>, C extends Config<E>>
extends DialogUIModel {
    public static final String CONFIG_PROPERTY_CHANGED = "config";
    public static final String MODIFIED_PROPERTY_CHANGED = "modify";
    public static final String UNVALID_PROPERTY_CHANGED = "unvalid";
    protected Object src;
    protected C current;
    protected EnumSet<E> modifieds;
    protected EnumSet<E> unvalids;
    protected Class<E> klass;
    protected EnumSet<E> uncheckedKeys;
    protected EnumSet<E> checkedKeysSet;

    protected abstract C newConfig();

    protected abstract boolean isValid(E var1, Object var2);

    protected DialogConfigUIModel(Class<E> klass) {
        this.klass = klass;
        this.current = this.newConfig();
        this.modifieds = EnumSet.noneOf(klass);
        this.unvalids = EnumSet.noneOf(klass);
    }

    public EnumSet<E> getCheckedKeysSet() {
        if (this.checkedKeysSet == null) {
            this.checkedKeysSet = this.uncheckedKeys != null ? EnumSet.complementOf(this.uncheckedKeys) : EnumSet.allOf(this.klass);
        }
        return this.checkedKeysSet;
    }

    public Object getSrc() {
        return this.src;
    }

    public C getCurrent() {
        return this.current;
    }

    public EnumSet<E> getUnivserse() {
        return this.getCurrent().getUniverse();
    }

    public EnumSet<E> getModifieds() {
        return this.modifieds;
    }

    public EnumSet<E> getUnvalids() {
        return this.unvalids;
    }

    public boolean isModified() {
        return !this.modifieds.isEmpty();
    }

    public boolean isConfigValid() {
        return this.unvalids.isEmpty();
    }

    public void populate(Object src) {
        this.src = src;
        this.current = this.newConfig();
        if (src != null) {
            this.current.copyFrom(src);
        }
        this.modifieds.clear();
        this.unvalids.clear();
        this.setModified(false);
        this.firePropertyChange(CONFIG_PROPERTY_CHANGED, null, this);
    }

    public void reset() {
        this.populate(this.src);
    }

    public void setModified(boolean modified) {
        this.firePropertyChange(MODIFIED_PROPERTY_CHANGED, null, modified);
    }

    public void setUnvalid(boolean unvalid) {
        this.firePropertyChange(UNVALID_PROPERTY_CHANGED, null, unvalid);
    }

    public void addModified(E key) {
        if (!this.modifieds.contains(key)) {
            this.modifieds.add(key);
            log.debug(key);
        }
        this.setModified(!this.modifieds.isEmpty());
    }

    public void removeModified(E key) {
        if (this.modifieds.contains(key)) {
            this.modifieds.remove(key);
        }
        this.setModified(!this.modifieds.isEmpty());
    }

    public void removeModified(EnumSet<E> keys) {
        for (Enum key : keys) {
            if (!this.modifieds.contains(key)) continue;
            this.modifieds.remove(key);
        }
        this.setModified(!this.modifieds.isEmpty());
    }

    public void setUnvalids(EnumSet<E> keys) {
        for (Enum key : keys) {
            if (this.unvalids.contains(key)) continue;
            this.unvalids.add(key);
        }
        for (Enum key : EnumSet.complementOf(keys)) {
            if (!this.unvalids.contains(key)) continue;
            this.unvalids.remove(key);
        }
        this.setUnvalid(!this.unvalids.isEmpty());
    }

    public void addUnvalid(E key) {
        if (!this.unvalids.contains(key)) {
            this.unvalids.add(key);
        }
        this.setUnvalid(!this.unvalids.isEmpty());
    }

    public void removeUnvalid(E key) {
        if (this.unvalids.contains(key)) {
            this.unvalids.remove(key);
        }
        this.setUnvalid(!this.unvalids.isEmpty());
    }

    public void save() {
        this.current.copyTo(this.src, this.modifieds);
        this.modifieds.clear();
        this.firePropertyChange(CONFIG_PROPERTY_CHANGED, null, this);
    }

    public void changeModifiedState(E key, Object uiValue, Object currentValue) {
        if (uiValue != null && uiValue.equals(currentValue)) {
            this.removeModified(key);
        } else {
            this.addModified(key);
        }
    }

    public void clear(E key) {
        log.info(key);
        this.modifieds.remove(key);
        this.unvalids.remove(key);
    }

    protected void validateProperty(E key, Object uiValue) {
        if (this.isValid(key, uiValue)) {
            this.removeUnvalid(key);
        } else {
            this.addUnvalid(key);
        }
    }
}

